/*
 * Decompiled with CFR 0.152.
 */
package org.qi4j.library.alarm;

import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import org.qi4j.api.constraint.Constraint;
import org.qi4j.api.constraint.ConstraintDeclaration;
import org.qi4j.api.constraint.Constraints;

@ConstraintDeclaration
@Retention(value=RetentionPolicy.RUNTIME)
@Constraints(value={AlarmNameConstraint.class})
public @interface AlarmNameFormat {
    public int minimumLength() default 5;

    public static class AlarmNameConstraint
    implements Constraint<AlarmNameFormat, String> {
        public boolean isValid(AlarmNameFormat annotation, String value) {
            String trimmed;
            int length = annotation.minimumLength();
            if (length < 1) {
                length = 1;
            }
            boolean lengthConstraint = (trimmed = value.trim()).length() >= length;
            boolean whiteSpaceConstraint = trimmed.length() > 0;
            return lengthConstraint && whiteSpaceConstraint;
        }
    }
}

