/*
 * Decompiled with CFR 0.152.
 */
package org.qi4j.library.alarm;

import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.ResourceBundle;
import org.qi4j.api.common.Optional;
import org.qi4j.api.common.UseDefaults;
import org.qi4j.api.injection.scope.Service;
import org.qi4j.api.injection.scope.This;
import org.qi4j.api.property.Property;
import org.qi4j.library.alarm.AlarmCategory;
import org.qi4j.library.alarm.AlarmClass;
import org.qi4j.library.alarm.AlarmEvent;
import org.qi4j.library.alarm.AlarmHistory;
import org.qi4j.library.alarm.AlarmListener;
import org.qi4j.library.alarm.AlarmModel;
import org.qi4j.library.alarm.AlarmNameFormat;
import org.qi4j.library.alarm.AlarmStatus;
import org.qi4j.library.alarm.AlarmSystem;

public interface AlarmPoint {
    public static final String STATUS_NORMAL = "Normal";
    public static final String STATUS_ACTIVATED = "Activated";
    public static final String STATUS_DEACTIVATED = "Deactivated";
    public static final String STATUS_REACTIVATED = "Reactivated";
    public static final String STATUS_ACKNOWLEDGED = "Acknowledged";
    public static final String STATUS_DISABLED = "Disabled";
    public static final String STATUS_BLOCKED = "Blocked";
    public static final String EVENT_ENABLING = "enabled";
    public static final String EVENT_DISABLING = "disabled";
    public static final String EVENT_BLOCKING = "blocked";
    public static final String EVENT_UNBLOCKING = "unblocked";
    public static final String EVENT_ACTIVATION = "activation";
    public static final String EVENT_DEACTIVATION = "deactivation";
    public static final String EVENT_ACKNOWLEDGEMENT = "acknowledgement";
    public static final String TRIGGER_ACTIVATE = "activate";
    public static final String TRIGGER_DEACTIVATE = "deactivate";
    public static final String TRIGGER_ACKNOWLEDGE = "acknowledge";
    public static final String TRIGGER_BLOCK = "block";
    public static final String TRIGGER_UNBLOCK = "unblock";
    public static final String TRIGGER_ENABLE = "enable";
    public static final String TRIGGER_DISABLE = "disable";

    public void trigger(String var1) throws IllegalArgumentException;

    public void activate();

    public void deactivate();

    public void acknowledge();

    public boolean currentCondition();

    public void updateCondition(boolean var1);

    public AlarmStatus currentStatus();

    public AlarmHistory history();

    public List<String> attributeNames();

    public String attribute(String var1);

    public void setAttribute(String var1, @Optional String var2);

    public String name();

    public String descriptionInDefaultLocale();

    public String description(Locale var1);

    @UseDefaults
    public Property<AlarmClass> alarmClass();

    public Property<AlarmCategory> category();

    public static abstract class AlarmPointMixin
    implements AlarmPoint {
        @Service
        private AlarmModel model;
        @Service
        private AlarmSystem alarmSystem;
        @This
        private AlarmPoint me;
        @This
        private AlarmState state;
        @This
        private AlarmHistory history;

        @Override
        public void setAttribute(String name, String value) {
            Map properties = (Map)this.state.attributes().get();
            if (value == null) {
                properties.remove(name);
            } else {
                properties.put(name, value);
            }
            this.state.attributes().set((Object)properties);
        }

        @Override
        public String attribute(String name) {
            return (String)((Map)this.state.attributes().get()).get(name);
        }

        @Override
        public List<String> attributeNames() {
            ArrayList<String> result = new ArrayList<String>();
            for (String name : ((Map)this.state.attributes().get()).keySet()) {
                result.add(name);
            }
            return result;
        }

        private void fireAlarm(AlarmEvent event) {
            for (AlarmListener listener : this.alarmSystem.alarmListeners()) {
                try {
                    listener.alarmFired(event);
                }
                catch (Exception e) {}
            }
        }

        public String toString() {
            return "AlarmPoint[" + this.name() + " : " + ((AlarmStatus)this.state.currentStatus().get()).name(null) + "  : " + this.descriptionInDefaultLocale() + "]";
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void trigger(String trigger) {
            AlarmEvent event;
            AlarmPointMixin alarmPointMixin = this;
            synchronized (alarmPointMixin) {
                event = this.model.evaluate(this.me, trigger);
                if (event == null) {
                    return;
                }
                this.state.currentStatus().set(event.newStatus().get());
                this.history.addEvent(event, trigger);
            }
            this.fireAlarm(event);
        }

        @Override
        public void activate() {
            this.trigger(AlarmPoint.TRIGGER_ACTIVATE);
        }

        @Override
        public void deactivate() {
            this.trigger(AlarmPoint.TRIGGER_DEACTIVATE);
        }

        @Override
        public void acknowledge() {
            this.trigger(AlarmPoint.TRIGGER_ACKNOWLEDGE);
        }

        @Override
        public AlarmHistory history() {
            return this.history;
        }

        @Override
        public AlarmStatus currentStatus() {
            return (AlarmStatus)this.state.currentStatus().get();
        }

        @Override
        public String name() {
            return (String)this.state.systemName().get();
        }

        @Override
        public String descriptionInDefaultLocale() {
            return this.description(null);
        }

        @Override
        public String description(Locale locale) {
            if (locale == null) {
                locale = Locale.getDefault();
            }
            ResourceBundle rb = ResourceBundle.getBundle("org.qi4j.library.alarm.user.AlarmDescriptions", locale);
            return rb.getString(this.name());
        }

        @Override
        public void updateCondition(boolean condition) {
            String trig = this.model.computeTrigger((AlarmStatus)this.state.currentStatus().get(), condition);
            if (trig != null) {
                this.trigger(trig);
            }
        }

        @Override
        public boolean currentCondition() {
            return this.model.computeCondition((AlarmStatus)this.state.currentStatus().get());
        }
    }

    public static interface AlarmState {
        @AlarmNameFormat
        public Property<String> systemName();

        @Optional
        public Property<String> description();

        @UseDefaults
        public Property<Map<String, String>> attributes();

        public Property<AlarmStatus> currentStatus();
    }
}

