/*
 * Decompiled with CFR 0.152.
 */
package org.qi4j.library.alarm;

import java.util.List;
import java.util.Locale;
import org.qi4j.api.common.Optional;
import org.qi4j.api.composite.TransientBuilder;
import org.qi4j.api.composite.TransientComposite;
import org.qi4j.api.concern.Concerns;
import org.qi4j.api.injection.scope.Service;
import org.qi4j.api.injection.scope.Structure;
import org.qi4j.api.injection.scope.Uses;
import org.qi4j.api.mixin.Mixins;
import org.qi4j.api.service.ServiceComposite;
import org.qi4j.api.structure.Module;
import org.qi4j.api.unitofwork.NoSuchEntityException;
import org.qi4j.api.unitofwork.UnitOfWork;
import org.qi4j.api.unitofwork.concern.UnitOfWorkConcern;
import org.qi4j.api.unitofwork.concern.UnitOfWorkPropagation;
import org.qi4j.library.alarm.AlarmClass;
import org.qi4j.library.alarm.AlarmHistory;
import org.qi4j.library.alarm.AlarmPoint;
import org.qi4j.library.alarm.AlarmPointFactory;
import org.qi4j.library.alarm.AlarmStatus;

@Concerns(value={UnitOfWorkConcern.class})
@Mixins(value={Mixin.class})
public interface AlarmProxy
extends AlarmPoint,
TransientComposite {

    public static abstract class Mixin
    implements AlarmPoint {
        @Structure
        private Module module;
        @Uses
        String identity;

        @Override
        @UnitOfWorkPropagation(value=UnitOfWorkPropagation.Propagation.REQUIRED)
        public void trigger(String trigger) throws IllegalArgumentException {
            AlarmPoint alarmPoint = this.findAlarmPoint();
            alarmPoint.trigger(trigger);
        }

        @Override
        @UnitOfWorkPropagation(value=UnitOfWorkPropagation.Propagation.REQUIRED)
        public void activate() {
            AlarmPoint alarmPoint = this.findAlarmPoint();
            alarmPoint.activate();
        }

        @Override
        @UnitOfWorkPropagation(value=UnitOfWorkPropagation.Propagation.REQUIRED)
        public void deactivate() {
            AlarmPoint alarmPoint = this.findAlarmPoint();
            alarmPoint.deactivate();
        }

        @Override
        @UnitOfWorkPropagation(value=UnitOfWorkPropagation.Propagation.REQUIRED)
        public void acknowledge() {
            AlarmPoint alarmPoint = this.findAlarmPoint();
            alarmPoint.acknowledge();
        }

        @Override
        @UnitOfWorkPropagation(value=UnitOfWorkPropagation.Propagation.REQUIRED)
        public boolean currentCondition() {
            AlarmPoint alarmPoint = this.findAlarmPoint();
            return alarmPoint.currentCondition();
        }

        @Override
        @UnitOfWorkPropagation(value=UnitOfWorkPropagation.Propagation.REQUIRED)
        public void updateCondition(boolean condition) {
            AlarmPoint alarmPoint = this.findAlarmPoint();
            alarmPoint.updateCondition(condition);
        }

        @Override
        @UnitOfWorkPropagation(value=UnitOfWorkPropagation.Propagation.REQUIRED)
        public AlarmStatus currentStatus() {
            AlarmPoint alarmPoint = this.findAlarmPoint();
            return alarmPoint.currentStatus();
        }

        @Override
        @UnitOfWorkPropagation(value=UnitOfWorkPropagation.Propagation.REQUIRED)
        public AlarmHistory history() {
            AlarmPoint alarmPoint = this.findAlarmPoint();
            return alarmPoint.history();
        }

        @Override
        @UnitOfWorkPropagation(value=UnitOfWorkPropagation.Propagation.REQUIRED)
        public List<String> attributeNames() {
            AlarmPoint alarmPoint = this.findAlarmPoint();
            return alarmPoint.attributeNames();
        }

        @Override
        @UnitOfWorkPropagation(value=UnitOfWorkPropagation.Propagation.REQUIRED)
        public String attribute(String name) {
            AlarmPoint alarmPoint = this.findAlarmPoint();
            return alarmPoint.attribute(name);
        }

        @Override
        @UnitOfWorkPropagation(value=UnitOfWorkPropagation.Propagation.REQUIRED)
        public void setAttribute(String name, @Optional String value) {
            AlarmPoint alarmPoint = this.findAlarmPoint();
            alarmPoint.setAttribute(name, value);
        }

        @Override
        @UnitOfWorkPropagation(value=UnitOfWorkPropagation.Propagation.REQUIRED)
        public String name() {
            AlarmPoint alarmPoint = this.findAlarmPoint();
            return alarmPoint.name();
        }

        @Override
        @UnitOfWorkPropagation(value=UnitOfWorkPropagation.Propagation.REQUIRED)
        public String descriptionInDefaultLocale() {
            AlarmPoint alarmPoint = this.findAlarmPoint();
            return alarmPoint.descriptionInDefaultLocale();
        }

        @Override
        @UnitOfWorkPropagation(value=UnitOfWorkPropagation.Propagation.REQUIRED)
        public String description(Locale locale) {
            AlarmPoint alarmPoint = this.findAlarmPoint();
            return alarmPoint.description(locale);
        }

        private AlarmPoint findAlarmPoint() {
            return (AlarmPoint)this.module.currentUnitOfWork().get(AlarmPoint.class, this.identity);
        }
    }

    public static abstract class FactoryMixin
    implements Factory {
        @Structure
        private Module module;
        @Service
        private AlarmPointFactory factory;

        @Override
        public AlarmProxy create(String identity, String systemName, String categoryName, AlarmClass alarmClass) {
            AlarmPoint alarmPoint;
            UnitOfWork unitOfWork = this.module.currentUnitOfWork();
            try {
                alarmPoint = (AlarmPoint)unitOfWork.get(AlarmPoint.class, identity);
            }
            catch (NoSuchEntityException e) {
                alarmPoint = this.factory.create(identity, systemName, categoryName, alarmClass);
            }
            TransientBuilder builder = this.module.newTransientBuilder(AlarmProxy.class);
            ((AlarmProxy)builder.prototype()).category().set(alarmPoint.category().get());
            ((AlarmProxy)builder.prototype()).alarmClass().set((Object)alarmClass);
            builder.use(new Object[]{identity});
            return (AlarmProxy)builder.newInstance();
        }
    }

    @Mixins(value={FactoryMixin.class})
    public static interface Factory
    extends ServiceComposite {
        @UnitOfWorkPropagation(value=UnitOfWorkPropagation.Propagation.REQUIRED)
        public AlarmProxy create(String var1, String var2, String var3, AlarmClass var4);
    }
}

