/*
 * Decompiled with CFR 0.152.
 */
package org.qi4j.library.alarm;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import java.util.ResourceBundle;
import org.qi4j.api.entity.Identity;
import org.qi4j.api.injection.scope.Structure;
import org.qi4j.api.mixin.Mixins;
import org.qi4j.api.service.ServiceComposite;
import org.qi4j.api.value.ValueBuilder;
import org.qi4j.api.value.ValueBuilderFactory;
import org.qi4j.library.alarm.AlarmEvent;
import org.qi4j.library.alarm.AlarmModel;
import org.qi4j.library.alarm.AlarmPoint;
import org.qi4j.library.alarm.AlarmStatus;

@Mixins(value={ExtendedAlarmModelMixin.class})
public interface ExtendedAlarmModelService
extends AlarmModel,
ServiceComposite {

    public static class ExtendedAlarmModelMixin
    implements AlarmModel {
        private static final List<String> TRIGGER_LIST;
        private static final List<String> STATUS_LIST;
        @Structure
        private ValueBuilderFactory vbf;

        static ResourceBundle getResourceBundle(Locale locale) {
            if (locale == null) {
                locale = Locale.getDefault();
            }
            ClassLoader cl = ExtendedAlarmModelMixin.class.getClassLoader();
            return ResourceBundle.getBundle("org.qi4j.library.alarm.AlarmResources", locale, cl);
        }

        @Override
        public String modelName() {
            return "org.qi4j.library.alarm.model.extended";
        }

        @Override
        public String modelDescription() {
            return this.modelDescription(null);
        }

        @Override
        public String modelDescription(Locale locale) {
            ResourceBundle rb = ExtendedAlarmModelMixin.getResourceBundle(locale);
            return rb.getString("MODEL_DESCRIPTION_EXTENDED");
        }

        @Override
        public AlarmEvent evaluate(AlarmPoint alarm, String trigger) {
            if (trigger.equals("activate")) {
                return this.activation(alarm);
            }
            if (trigger.equals("deactivate")) {
                return this.deactivation(alarm);
            }
            if (trigger.equals("acknowledge")) {
                return this.acknowledge(alarm);
            }
            if (trigger.equals("block")) {
                return this.block(alarm);
            }
            if (trigger.equals("unblock")) {
                return this.unblock(alarm);
            }
            if (trigger.equals("enable")) {
                return this.enable(alarm);
            }
            if (trigger.equals("disable")) {
                return this.disable(alarm);
            }
            throw new IllegalArgumentException("'" + trigger + "' is not supported by this AlarmModel.");
        }

        @Override
        public List<String> alarmTriggers() {
            return TRIGGER_LIST;
        }

        @Override
        public List<String> statusList() {
            return STATUS_LIST;
        }

        @Override
        public String computeTrigger(AlarmStatus status, boolean condition) {
            if (condition) {
                if (status.name(null).equals("Deactivated") || status.name(null).equals("Normal")) {
                    return "activate";
                }
            } else if (status.name(null).equals("Activated") || status.name(null).equals("Reactivated") || status.name(null).equals("Acknowledged")) {
                return "deactivate";
            }
            return null;
        }

        @Override
        public boolean computeCondition(AlarmStatus status) {
            return status.name(null).equals("Activated") || status.name(null).equals("Reactivated") || status.name(null).equals("Acknowledged");
        }

        private AlarmEvent activation(AlarmPoint alarm) {
            AlarmStatus status = alarm.currentStatus();
            if (status.name(null).equals("Normal") || status.name(null).equals("Deactivated")) {
                AlarmStatus newStatus = this.createStatus("Activated");
                return this.createEvent((Identity)alarm, status, newStatus, "activation");
            }
            return null;
        }

        private AlarmEvent deactivation(AlarmPoint alarm) {
            AlarmStatus status = alarm.currentStatus();
            if (status.name(null).equals("Acknowledged")) {
                AlarmStatus newStatus = this.createStatus("Normal");
                return this.createEvent((Identity)alarm, status, newStatus, "deactivation");
            }
            if (status.name(null).equals("Activated")) {
                AlarmStatus newStatus = this.createStatus("Deactivated");
                return this.createEvent((Identity)alarm, status, newStatus, "deactivation");
            }
            return null;
        }

        private AlarmEvent acknowledge(AlarmPoint alarm) {
            AlarmStatus status = alarm.currentStatus();
            if (status.name(null).equals("Deactivated")) {
                AlarmStatus newStatus = this.createStatus("Normal");
                return this.createEvent((Identity)alarm, status, newStatus, "acknowledgement");
            }
            if (status.name(null).equals("Activated")) {
                AlarmStatus newStatus = this.createStatus("Acknowledged");
                return this.createEvent((Identity)alarm, status, newStatus, "acknowledgement");
            }
            return null;
        }

        private AlarmEvent block(AlarmPoint alarm) {
            AlarmStatus status = alarm.currentStatus();
            if (status.name(null).equals("Blocked") || status.name(null).equals("Disabled")) {
                return null;
            }
            AlarmStatus newStatus = this.createStatus("Blocked");
            return this.createEvent((Identity)alarm, status, newStatus, "blocked");
        }

        private AlarmEvent unblock(AlarmPoint alarm) {
            AlarmStatus status = alarm.currentStatus();
            if (status.name(null).equals("Blocked")) {
                AlarmStatus newStatus = this.createStatus("Normal");
                return this.createEvent((Identity)alarm, status, newStatus, "unblocked");
            }
            return null;
        }

        private AlarmEvent disable(AlarmPoint alarm) {
            AlarmStatus status = alarm.currentStatus();
            if (status.name(null).equals("Disabled")) {
                return null;
            }
            AlarmStatus newStatus = this.createStatus("Disabled");
            return this.createEvent((Identity)alarm, status, newStatus, "disabled");
        }

        private AlarmEvent enable(AlarmPoint alarm) {
            AlarmStatus status = alarm.currentStatus();
            if (status.name(null).equals("Disabled")) {
                AlarmStatus newStatus = this.createStatus("Normal");
                return this.createEvent((Identity)alarm, status, newStatus, "enabled");
            }
            return null;
        }

        private AlarmStatus createStatus(String status) {
            ValueBuilder builder = this.vbf.newValueBuilder(AlarmStatus.class);
            AlarmStatus.State prototype = (AlarmStatus.State)builder.prototypeFor(AlarmStatus.State.class);
            prototype.name().set((Object)status);
            prototype.creationDate().set((Object)new Date());
            return (AlarmStatus)builder.newInstance();
        }

        private AlarmEvent createEvent(Identity alarmId, AlarmStatus oldStatus, AlarmStatus newStatus, String eventSystemName) {
            ValueBuilder builder = this.vbf.newValueBuilder(AlarmEvent.class);
            AlarmEvent prototype = (AlarmEvent)builder.prototype();
            prototype.alarmIdentity().set(alarmId.identity().get());
            prototype.eventTime().set((Object)new Date());
            prototype.newStatus().set((Object)newStatus);
            prototype.oldStatus().set((Object)oldStatus);
            prototype.systemName().set((Object)eventSystemName);
            return (AlarmEvent)builder.newInstance();
        }

        static {
            ArrayList<String> list1 = new ArrayList<String>();
            list1.add("Normal");
            list1.add("Activated");
            list1.add("Deactivated");
            list1.add("Acknowledged");
            list1.add("Reactivated");
            list1.add("Blocked");
            list1.add("Disabled");
            STATUS_LIST = Collections.unmodifiableList(list1);
            ArrayList<String> list2 = new ArrayList<String>();
            list2.add("activate");
            list2.add("deactivate");
            list2.add("acknowledge");
            list2.add("block");
            list2.add("unblock");
            list2.add("disable");
            list2.add("enable");
            TRIGGER_LIST = Collections.unmodifiableList(list2);
        }
    }
}

