/*
 * Decompiled with CFR 0.152.
 */
package org.qi4j.library.alarm;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import java.util.ResourceBundle;
import org.qi4j.api.entity.Identity;
import org.qi4j.api.injection.scope.Structure;
import org.qi4j.api.mixin.Mixins;
import org.qi4j.api.service.ServiceComposite;
import org.qi4j.api.value.ValueBuilder;
import org.qi4j.api.value.ValueBuilderFactory;
import org.qi4j.library.alarm.AlarmEvent;
import org.qi4j.library.alarm.AlarmModel;
import org.qi4j.library.alarm.AlarmPoint;
import org.qi4j.library.alarm.AlarmStatus;

@Mixins(value={SimpleAlarmModelMixin.class})
public interface SimpleAlarmModelService
extends AlarmModel,
ServiceComposite {

    public static class SimpleAlarmModelMixin
    implements AlarmModel {
        private static final List<String> ALARM_TRIGGERS;
        private static final List<String> ALARM_STATUSES;
        @Structure
        private ValueBuilderFactory vbf;

        static ResourceBundle getResourceBundle(Locale locale) {
            if (locale == null) {
                locale = Locale.getDefault();
            }
            ClassLoader cl = SimpleAlarmModelMixin.class.getClassLoader();
            return ResourceBundle.getBundle("org.qi4j.library.alarm.AlarmResources", locale, cl);
        }

        @Override
        public String modelName() {
            return "org.qi4j.library.alarm.model.simple";
        }

        @Override
        public String modelDescription() {
            return this.modelDescription(null);
        }

        @Override
        public String modelDescription(Locale locale) {
            ResourceBundle rb = SimpleAlarmModelMixin.getResourceBundle(locale);
            return rb.getString("MODEL_DESCRIPTION_SIMPLE");
        }

        @Override
        public List<String> statusList() {
            return ALARM_STATUSES;
        }

        @Override
        public AlarmEvent evaluate(AlarmPoint alarm, String trigger) {
            if (trigger.equals("activate")) {
                return this.activation(alarm);
            }
            if (trigger.equals("deactivate")) {
                return this.deactivation(alarm);
            }
            throw new IllegalArgumentException("'" + trigger + "' is not supported by this AlarmModel.");
        }

        @Override
        public List<String> alarmTriggers() {
            return ALARM_TRIGGERS;
        }

        @Override
        public String computeTrigger(AlarmStatus status, boolean condition) {
            if (condition) {
                if ("Normal".equals(status.name(null))) {
                    return "activate";
                }
            } else if ("Activated".equals(status.name(null))) {
                return "deactivate";
            }
            return null;
        }

        @Override
        public boolean computeCondition(AlarmStatus status) {
            return status.name(null).equals("Activated");
        }

        private AlarmEvent activation(AlarmPoint alarm) {
            AlarmStatus oldStatus = alarm.currentStatus();
            if (oldStatus.name(null).equals("Normal")) {
                AlarmStatus newStatus = this.createStatus("Activated");
                return this.createEvent((Identity)alarm, oldStatus, newStatus, "activation");
            }
            return null;
        }

        private AlarmEvent deactivation(AlarmPoint alarm) {
            AlarmStatus oldStatus = alarm.currentStatus();
            if (oldStatus.name(null).equals("Activated")) {
                AlarmStatus newStatus = this.createStatus("Normal");
                return this.createEvent((Identity)alarm, oldStatus, newStatus, "deactivation");
            }
            return null;
        }

        private AlarmStatus createStatus(String status) {
            ValueBuilder builder = this.vbf.newValueBuilder(AlarmStatus.class);
            AlarmStatus.State prototype = (AlarmStatus.State)builder.prototypeFor(AlarmStatus.State.class);
            prototype.name().set((Object)status);
            prototype.creationDate().set((Object)new Date());
            return (AlarmStatus)builder.newInstance();
        }

        private AlarmEvent createEvent(Identity alarmId, AlarmStatus oldStatus, AlarmStatus newStatus, String eventSystemName) {
            ValueBuilder builder = this.vbf.newValueBuilder(AlarmEvent.class);
            AlarmEvent prototype = (AlarmEvent)builder.prototype();
            prototype.alarmIdentity().set(alarmId.identity().get());
            prototype.eventTime().set((Object)new Date());
            prototype.newStatus().set((Object)newStatus);
            prototype.oldStatus().set((Object)oldStatus);
            prototype.systemName().set((Object)eventSystemName);
            return (AlarmEvent)builder.newInstance();
        }

        static {
            ArrayList<String> list1 = new ArrayList<String>();
            list1.add("activate");
            list1.add("deactivate");
            ALARM_TRIGGERS = Collections.unmodifiableList(list1);
            ArrayList<String> list2 = new ArrayList<String>();
            list2.add("Normal");
            list2.add("Activated");
            ALARM_STATUSES = Collections.unmodifiableList(list2);
        }
    }
}

