/*
 * Decompiled with CFR 0.152.
 */
package org.qi4j.library.sql.liquibase;

import java.net.ConnectException;
import java.sql.Connection;
import java.sql.SQLException;
import javax.sql.DataSource;
import liquibase.Liquibase;
import liquibase.database.DatabaseConnection;
import liquibase.database.jvm.JdbcConnection;
import liquibase.resource.ClassLoaderResourceAccessor;
import liquibase.resource.ResourceAccessor;
import org.qi4j.api.activation.ActivatorAdapter;
import org.qi4j.api.activation.Activators;
import org.qi4j.api.configuration.Configuration;
import org.qi4j.api.injection.scope.Service;
import org.qi4j.api.injection.scope.This;
import org.qi4j.api.mixin.Mixins;
import org.qi4j.api.service.ServiceComposite;
import org.qi4j.api.service.ServiceImporterException;
import org.qi4j.api.service.ServiceReference;
import org.qi4j.library.sql.common.SQLUtil;
import org.qi4j.library.sql.liquibase.LiquibaseConfiguration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Mixins(value={Mixin.class})
@Activators(value={Activator.class})
public interface LiquibaseService
extends ServiceComposite {
    public void activateLiquibase() throws Exception;

    public static abstract class Mixin
    implements LiquibaseService {
        private static final Logger LOGGER = LoggerFactory.getLogger((String)"org.qi4j.library.sql");
        @This
        Configuration<LiquibaseConfiguration> config;
        @Service
        ServiceReference<DataSource> dataSource;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Loose catch block
         */
        @Override
        public void activateLiquibase() throws Exception {
            this.config.refresh();
            boolean enabled = (Boolean)((LiquibaseConfiguration)this.config.get()).enabled().get();
            if (!enabled) {
                return;
            }
            Connection connection = null;
            try {
                connection = ((DataSource)this.dataSource.get()).getConnection();
                JdbcConnection dc = new JdbcConnection(connection);
                Liquibase liquibase = new Liquibase((String)((LiquibaseConfiguration)this.config.get()).changeLog().get(), (ResourceAccessor)new ClassLoaderResourceAccessor(), (DatabaseConnection)dc);
                liquibase.update((String)((LiquibaseConfiguration)this.config.get()).contexts().get());
            }
            catch (SQLException e) {
                block9: {
                    Throwable ex = e;
                    while (ex.getCause() != null) {
                        ex = ex.getCause();
                    }
                    if (!(ex instanceof ConnectException)) break block9;
                    LOGGER.warn("Could not connect to database; Liquibase should be disabled");
                    SQLUtil.rollbackQuietly((Connection)connection);
                    SQLUtil.closeQuietly((Connection)connection);
                    return;
                }
                LOGGER.error("Liquibase could not perform database migration", (Throwable)e);
                SQLUtil.rollbackQuietly((Connection)connection);
                SQLUtil.closeQuietly((Connection)connection);
            }
            catch (ServiceImporterException ex) {
                LOGGER.warn("DataSource is not available - database refactoring skipped");
                {
                    catch (Throwable throwable) {
                        SQLUtil.rollbackQuietly(connection);
                        SQLUtil.closeQuietly((Connection)connection);
                        throw throwable;
                    }
                }
                SQLUtil.rollbackQuietly((Connection)connection);
                SQLUtil.closeQuietly((Connection)connection);
            }
            SQLUtil.rollbackQuietly((Connection)connection);
            SQLUtil.closeQuietly((Connection)connection);
        }
    }

    public static class Activator
    extends ActivatorAdapter<ServiceReference<LiquibaseService>> {
        public void afterActivation(ServiceReference<LiquibaseService> activated) throws Exception {
            ((LiquibaseService)activated.get()).activateLiquibase();
        }
    }
}

