/*
 * Decompiled with CFR 0.152.
 */
package org.qi4j.library.spring.bootstrap.internal.application;

import org.qi4j.api.structure.Application;
import org.qi4j.bootstrap.ApplicationAssembler;
import org.qi4j.bootstrap.ApplicationAssembly;
import org.qi4j.bootstrap.ApplicationAssemblyFactory;
import org.qi4j.bootstrap.AssemblyException;
import org.qi4j.bootstrap.Energy4Java;
import org.qi4j.library.spring.bootstrap.Qi4jApplicationBootstrap;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.BeanInitializationException;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.FactoryBean;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.util.Assert;

public final class Qi4jApplicationFactoryBean
implements FactoryBean,
DisposableBean,
InitializingBean,
ApplicationContextAware {
    private final Qi4jApplicationBootstrap applicationBootstrap;
    private Application application;

    public Qi4jApplicationFactoryBean(Qi4jApplicationBootstrap applicationBootstrap) {
        Assert.notNull((Object)applicationBootstrap, (String)"'applicationBootstrap' must not be null");
        this.applicationBootstrap = applicationBootstrap;
    }

    public final Application getObject() throws Exception {
        if (this.application == null) {
            this.application = this.createApplication();
        }
        return this.application;
    }

    public final Class<Application> getObjectType() {
        return Application.class;
    }

    public final boolean isSingleton() {
        return true;
    }

    public final void destroy() throws Exception {
        this.getObject().passivate();
    }

    public final void afterPropertiesSet() throws Exception {
        this.getObject().activate();
    }

    private Application createApplication() {
        Energy4Java energy4Java = new Energy4Java();
        try {
            return energy4Java.newApplication(new ApplicationAssembler(){

                public ApplicationAssembly assemble(ApplicationAssemblyFactory applicationFactory) throws AssemblyException {
                    ApplicationAssembly applicationAssembly = applicationFactory.newApplicationAssembly();
                    Qi4jApplicationFactoryBean.this.applicationBootstrap.assemble(applicationAssembly);
                    return applicationAssembly;
                }
            }, new Object[0]);
        }
        catch (AssemblyException e) {
            throw new BeanInitializationException("Fail to bootstrap qi4j application.", (Throwable)e);
        }
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        if (this.applicationBootstrap instanceof ApplicationContextAware) {
            ApplicationContextAware aware = (ApplicationContextAware)this.applicationBootstrap;
            aware.setApplicationContext(applicationContext);
        }
    }
}

