/*
 * Decompiled with CFR 0.152.
 */
package org.qi4j.library.spring.bootstrap.internal.application;

import org.qi4j.library.spring.bootstrap.Qi4jApplicationBootstrap;
import org.qi4j.library.spring.bootstrap.internal.application.Qi4jApplicationFactoryBean;
import org.springframework.beans.BeanInstantiationException;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.support.AbstractBeanDefinition;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.beans.factory.xml.BeanDefinitionParser;
import org.springframework.beans.factory.xml.ParserContext;
import org.springframework.beans.factory.xml.XmlReaderContext;
import org.springframework.util.Assert;
import org.springframework.util.ClassUtils;
import org.w3c.dom.Element;

public final class Qi4jBootstrapBeanDefinitionParser
implements BeanDefinitionParser {
    private static final String CLASS = "class";

    public final BeanDefinition parse(Element anElement, ParserContext aParserContext) {
        Qi4jApplicationBootstrap bootstrap = this.createQi4jApplicationBootstrap(anElement, aParserContext);
        AbstractBeanDefinition factoryBeanDefinition = this.createQi4jApplicationFactoryBeanDefinition(bootstrap);
        this.registerBean(aParserContext, (BeanDefinition)factoryBeanDefinition);
        return factoryBeanDefinition;
    }

    private Qi4jApplicationBootstrap createQi4jApplicationBootstrap(Element anElement, ParserContext aParserContext) {
        Class bootstrapClass;
        String bootstrapClassString = anElement.getAttribute(CLASS);
        Assert.hasText((String)bootstrapClassString);
        XmlReaderContext readerContext = aParserContext.getReaderContext();
        try {
            bootstrapClass = ClassUtils.forName((String)bootstrapClassString, (ClassLoader)this.getClass().getClassLoader());
        }
        catch (ClassNotFoundException e) {
            readerContext.error("Zest bootstrap class [" + bootstrapClassString + "] is not found.", (Object)anElement);
            return null;
        }
        if (!Qi4jApplicationBootstrap.class.isAssignableFrom(bootstrapClass)) {
            readerContext.error("classattribute is not an instance of [" + Qi4jApplicationBootstrap.class.getName() + "] class", (Object)anElement);
            return null;
        }
        Qi4jApplicationBootstrap bootstrap = null;
        try {
            bootstrap = (Qi4jApplicationBootstrap)BeanUtils.instantiateClass((Class)bootstrapClass);
        }
        catch (BeanInstantiationException e) {
            readerContext.error("Fail to instantiate qi4j bootstrap class [" + bootstrapClassString + "]", (Object)anElement, (Throwable)e);
        }
        return bootstrap;
    }

    private AbstractBeanDefinition createQi4jApplicationFactoryBeanDefinition(Qi4jApplicationBootstrap applicationBootstrap) {
        BeanDefinitionBuilder builder = BeanDefinitionBuilder.rootBeanDefinition(Qi4jApplicationFactoryBean.class);
        builder.addConstructorArgValue((Object)applicationBootstrap);
        return builder.getBeanDefinition();
    }

    private void registerBean(ParserContext aParserContext, BeanDefinition aBeanDefinition) {
        BeanDefinitionRegistry registry = aParserContext.getRegistry();
        registry.registerBeanDefinition("qi4jApplication", aBeanDefinition);
    }
}

