/*
 * Decompiled with CFR 0.152.
 */
package org.qi4j.library.spring.bootstrap.internal.service;

import org.qi4j.api.service.ServiceReference;
import org.qi4j.api.structure.Application;
import org.qi4j.functional.HierarchicalVisitor;
import org.qi4j.functional.Iterables;
import org.qi4j.library.spring.bootstrap.internal.service.ServiceLocator;
import org.springframework.beans.factory.FactoryBean;
import org.springframework.util.Assert;

public final class ServiceFactoryBean
implements FactoryBean {
    private ServiceReference serviceReference;

    public ServiceFactoryBean(Application anApplication, String aServiceId) throws IllegalArgumentException {
        Assert.notNull((Object)anApplication, (String)"Argument [anApplication] must not be [null].");
        Assert.notNull((Object)aServiceId, (String)"Argument [aServiceId] must not be [null].");
        ServiceLocator serviceLocator = new ServiceLocator(aServiceId);
        anApplication.descriptor().accept((HierarchicalVisitor)serviceLocator);
        this.serviceReference = serviceLocator.locateService(anApplication);
        if (this.serviceReference == null) {
            throw new IllegalArgumentException("Zest service with id [" + aServiceId + "] is not found.");
        }
    }

    public final Object getObject() throws Exception {
        return this.serviceReference.get();
    }

    public final Class getObjectType() {
        return (Class)Iterables.first((Iterable)this.serviceReference.types());
    }

    public final boolean isSingleton() {
        return false;
    }
}

