/*
 * Decompiled with CFR 0.152.
 */
package org.qi4j.library.spring.bootstrap.internal.service;

import org.qi4j.api.object.ObjectDescriptor;
import org.qi4j.api.service.ImportedServiceDescriptor;
import org.qi4j.api.service.ServiceDescriptor;
import org.qi4j.api.service.ServiceReference;
import org.qi4j.api.structure.Application;
import org.qi4j.api.structure.ApplicationDescriptor;
import org.qi4j.api.structure.LayerDescriptor;
import org.qi4j.api.structure.Module;
import org.qi4j.api.structure.ModuleDescriptor;
import org.qi4j.functional.HierarchicalVisitor;
import org.qi4j.functional.Iterables;

final class ServiceLocator
implements HierarchicalVisitor<Object, Object, RuntimeException> {
    private final String serviceId;
    private Class serviceType;
    private String moduleName;
    private String layerName;
    private String tempLayerName;
    private String tempModuleName;

    ServiceLocator(String serviceId) {
        this.serviceId = serviceId;
    }

    public boolean visitEnter(Object visited) throws RuntimeException {
        if (visited instanceof ApplicationDescriptor) {
            return true;
        }
        if (visited instanceof LayerDescriptor) {
            this.tempLayerName = ((LayerDescriptor)visited).name();
            return true;
        }
        if (visited instanceof ModuleDescriptor) {
            this.tempModuleName = ((ModuleDescriptor)visited).name();
            return true;
        }
        if (visited instanceof ServiceDescriptor) {
            ServiceDescriptor aDescriptor = (ServiceDescriptor)visited;
            String identity = aDescriptor.identity();
            if (this.serviceId.equals(identity)) {
                this.layerName = this.tempLayerName;
                this.moduleName = this.tempModuleName;
                this.serviceType = (Class)Iterables.first((Iterable)aDescriptor.types());
            }
        } else if (visited instanceof ObjectDescriptor) {
            return false;
        }
        return true;
    }

    public boolean visitLeave(Object visited) throws RuntimeException {
        return true;
    }

    public boolean visit(Object visited) throws RuntimeException {
        ImportedServiceDescriptor aDescriptor;
        String identity;
        if (visited instanceof ImportedServiceDescriptor && this.serviceId.equals(identity = (aDescriptor = (ImportedServiceDescriptor)visited).identity())) {
            this.layerName = this.tempLayerName;
            this.moduleName = this.tempModuleName;
            this.serviceType = aDescriptor.type();
        }
        return true;
    }

    ServiceReference locateService(Application anApplication) {
        if (this.layerName != null) {
            Module module = anApplication.findModule(this.layerName, this.moduleName);
            Iterable serviceRefs = module.findServices(this.serviceType);
            for (ServiceReference serviceRef : serviceRefs) {
                if (!this.serviceId.equals(serviceRef.identity())) continue;
                return serviceRef;
            }
        }
        return null;
    }
}

