/*
 * Decompiled with CFR 0.152.
 */
package org.qi4j.index.solr;

import java.io.File;
import java.lang.reflect.Field;
import org.apache.solr.client.solrj.SolrServer;
import org.apache.solr.client.solrj.embedded.EmbeddedSolrServer;
import org.apache.solr.core.CoreContainer;
import org.apache.solr.core.SolrConfig;
import org.apache.solr.core.SolrCore;
import org.qi4j.api.activation.ActivatorAdapter;
import org.qi4j.api.activation.Activators;
import org.qi4j.api.injection.scope.Service;
import org.qi4j.api.injection.scope.Uses;
import org.qi4j.api.mixin.Mixins;
import org.qi4j.api.service.ServiceComposite;
import org.qi4j.api.service.ServiceDescriptor;
import org.qi4j.api.service.ServiceReference;
import org.qi4j.library.fileconfig.FileConfiguration;

@Mixins(value={Mixin.class})
@Activators(value={Activator.class})
public interface EmbeddedSolrService
extends ServiceComposite {
    public SolrServer solrServer();

    public SolrCore solrCore();

    public void activateSolr() throws Exception;

    public void passivateSolr() throws Exception;

    public static abstract class Mixin
    implements EmbeddedSolrService {
        @Service
        FileConfiguration fileConfig;
        public CoreContainer coreContainer;
        public EmbeddedSolrServer server;
        @Uses
        ServiceDescriptor descriptor;
        private SolrCore core;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void activateSolr() throws Exception {
            ClassLoader oldCl = Thread.currentThread().getContextClassLoader();
            Thread.currentThread().setContextClassLoader(this.getClass().getClassLoader());
            try {
                File directory = new File(this.fileConfig.dataDirectory(), this.descriptor.identity());
                directory.mkdir();
                System.setProperty("solr.solr.home", directory.getAbsolutePath());
                CoreContainer.Initializer initializer = new CoreContainer.Initializer();
                this.coreContainer = initializer.initialize();
                this.server = new EmbeddedSolrServer(this.coreContainer, "");
                this.core = this.coreContainer.getCore("");
            }
            finally {
                Thread.currentThread().setContextClassLoader(oldCl);
            }
        }

        @Override
        public void passivateSolr() throws Exception {
            this.core.closeSearcher();
            this.coreContainer.shutdown();
            Field instanceField = SolrCore.class.getDeclaredField("instance");
            instanceField.setAccessible(true);
            instanceField.set(null, null);
            SolrConfig.config = null;
        }

        @Override
        public SolrServer solrServer() {
            return this.server;
        }

        @Override
        public SolrCore solrCore() {
            return this.core;
        }
    }

    public static class Activator
    extends ActivatorAdapter<ServiceReference<EmbeddedSolrService>> {
        public void afterActivation(ServiceReference<EmbeddedSolrService> activated) throws Exception {
            ((EmbeddedSolrService)activated.get()).activateSolr();
        }

        public void beforePassivation(ServiceReference<EmbeddedSolrService> passivating) throws Exception {
            ((EmbeddedSolrService)passivating.get()).passivateSolr();
        }
    }
}

