/*
 * Decompiled with CFR 0.152.
 */
package org.qi4j.index.solr.internal;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.Map;
import org.apache.solr.client.solrj.SolrServer;
import org.apache.solr.client.solrj.SolrServerException;
import org.apache.solr.common.SolrInputDocument;
import org.apache.solr.core.SolrCore;
import org.apache.solr.schema.SchemaField;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import org.openrdf.model.BNode;
import org.openrdf.model.Graph;
import org.openrdf.model.Literal;
import org.openrdf.model.Resource;
import org.openrdf.model.Statement;
import org.openrdf.model.URI;
import org.openrdf.model.ValueFactory;
import org.openrdf.model.impl.GraphImpl;
import org.openrdf.model.impl.URIImpl;
import org.openrdf.model.impl.ValueFactoryImpl;
import org.qi4j.api.injection.scope.Service;
import org.qi4j.api.injection.scope.Uses;
import org.qi4j.functional.Iterables;
import org.qi4j.index.solr.EmbeddedSolrService;
import org.qi4j.index.solr.SolrQueryService;
import org.qi4j.library.rdf.entity.EntityStateSerializer;
import org.qi4j.spi.entity.EntityState;
import org.qi4j.spi.entity.EntityStatus;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class SolrEntityIndexerMixin
implements SolrQueryService {
    @Service
    private EmbeddedSolrService solr;
    @Uses
    private EntityStateSerializer stateSerializer;
    private ValueFactory valueFactory = new ValueFactoryImpl();
    private SolrServer server;
    private Map<String, SchemaField> indexedFields;
    Logger logger = LoggerFactory.getLogger(this.getClass());

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void inflateSolrSchema() {
        this.server = this.solr.solrServer();
        try (SolrCore solrCore = this.solr.solrCore();){
            this.indexedFields = solrCore.getSchema().getFields();
        }
    }

    @Override
    public void releaseSolrSchema() {
        this.server = null;
        this.indexedFields = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void notifyChanges(Iterable<EntityState> entityStates) {
        try {
            try {
                ArrayList<String> deleted = null;
                ArrayList<SolrInputDocument> added = new ArrayList<SolrInputDocument>();
                for (EntityState entityState : entityStates) {
                    if (!entityState.entityDescriptor().queryable()) continue;
                    if (entityState.status().equals((Object)EntityStatus.REMOVED)) {
                        if (deleted == null) {
                            deleted = new ArrayList<String>();
                        }
                        deleted.add(entityState.identity().identity());
                        continue;
                    }
                    if (entityState.status().equals((Object)EntityStatus.UPDATED)) {
                        added.add(this.indexEntityState(entityState, this.server));
                        continue;
                    }
                    if (!entityState.status().equals((Object)EntityStatus.NEW)) continue;
                    added.add(this.indexEntityState(entityState, this.server));
                }
                if (deleted != null) {
                    this.server.deleteById(deleted);
                }
                if (!added.isEmpty()) {
                    this.server.add(added);
                }
            }
            finally {
                if (this.server != null) {
                    this.server.commit(false, false);
                }
            }
        }
        catch (Throwable e) {
            this.logger.error("Could not update Solr", e);
        }
    }

    private SolrInputDocument indexEntityState(EntityState entityState, SolrServer server) throws IOException, SolrServerException, JSONException {
        GraphImpl graph = new GraphImpl();
        this.stateSerializer.serialize(entityState, false, (Graph)graph);
        SolrInputDocument input = new SolrInputDocument();
        input.addField("id", (Object)entityState.identity().identity());
        input.addField("type", (Object)((Class)Iterables.first((Iterable)entityState.entityDescriptor().types())).getName());
        input.addField("lastModified", (Object)new Date(entityState.lastModified()));
        for (Statement statement : graph) {
            String value;
            SchemaField field = this.indexedFields.get(statement.getPredicate().getLocalName());
            if (field == null) continue;
            if (statement.getObject() instanceof Literal) {
                value = statement.getObject().stringValue();
                if (field.getType().getTypeName().equals("json")) {
                    if (value.charAt(0) == '[') {
                        JSONArray array = new JSONArray(value);
                        this.indexJson(input, array);
                        continue;
                    }
                    if (value.charAt(0) != '{') continue;
                    JSONObject object = new JSONObject(value);
                    this.indexJson(input, object);
                    continue;
                }
                input.addField(field.getName(), (Object)value);
                continue;
            }
            if (statement.getObject() instanceof URI && !"type".equals(field.getName())) {
                value = statement.getObject().stringValue();
                value = value.substring(value.lastIndexOf(58) + 1, value.length());
                String name = field.getName();
                input.addField(name, (Object)value);
                continue;
            }
            if (!(statement.getObject() instanceof BNode)) continue;
            Resource resource = (Resource)statement.getObject();
            URIImpl uri = new URIImpl("http://www.w3.org/1999/02/22-rdf-syntax-ns#li");
            Iterator seq = graph.match(resource, (URI)uri, null, new Resource[]{null});
            while (seq.hasNext()) {
                Statement seqStatement = (Statement)seq.next();
                String value2 = seqStatement.getObject().stringValue();
                value2 = value2.substring(value2.lastIndexOf(58) + 1, value2.length());
                input.addField(field.getName(), (Object)value2);
            }
        }
        return input;
    }

    private void indexJson(SolrInputDocument input, Object object) throws JSONException {
        if (object instanceof JSONArray) {
            JSONArray array = (JSONArray)object;
            for (int i = 0; i < array.length(); ++i) {
                this.indexJson(input, array.get(i));
            }
        } else {
            JSONObject jsonObject = (JSONObject)object;
            Iterator keys = jsonObject.keys();
            while (keys.hasNext()) {
                Object name = keys.next();
                Object value = jsonObject.get(name.toString());
                if (value instanceof JSONObject || value instanceof JSONArray) {
                    this.indexJson(input, value);
                    continue;
                }
                SchemaField field = this.indexedFields.get(name.toString());
                if (field == null) continue;
                input.addField(name.toString(), jsonObject.get(name.toString()));
            }
        }
    }
}

