/*
 * Decompiled with CFR 0.152.
 */
package org.qi4j.logging.debug.service;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.qi4j.api.Qi4j;
import org.qi4j.api.composite.Composite;
import org.qi4j.api.composite.CompositeDescriptor;
import org.qi4j.api.configuration.Configuration;
import org.qi4j.api.entity.EntityBuilder;
import org.qi4j.api.entity.EntityComposite;
import org.qi4j.api.injection.scope.Structure;
import org.qi4j.api.injection.scope.This;
import org.qi4j.api.service.ServiceComposite;
import org.qi4j.api.unitofwork.ConcurrentEntityModificationException;
import org.qi4j.api.unitofwork.UnitOfWork;
import org.qi4j.api.unitofwork.UnitOfWorkCompletionException;
import org.qi4j.api.unitofwork.UnitOfWorkFactory;
import org.qi4j.functional.Iterables;
import org.qi4j.logging.debug.records.CompositeDebugRecordEntity;
import org.qi4j.logging.debug.records.DebugRecord;
import org.qi4j.logging.debug.records.EntityDebugRecordEntity;
import org.qi4j.logging.debug.records.ServiceDebugRecordEntity;
import org.qi4j.logging.debug.service.DebugServiceConfiguration;
import org.qi4j.logging.debug.service.DebuggingService;

public class DebuggingServiceMixin
implements DebuggingService {
    @Structure
    private UnitOfWorkFactory uowf;
    @This
    private Configuration<DebugServiceConfiguration> configuration;

    @Override
    public int debugLevel() {
        return (Integer)((DebugServiceConfiguration)this.configuration.get()).debugLevel().get();
    }

    @Override
    public void debug(Composite composite, String message) {
        UnitOfWork uow = this.uowf.newUnitOfWork();
        try {
            ArrayList<Serializable> paramsList = new ArrayList<Serializable>();
            this.createDebugRecord(uow, composite, message, paramsList);
            uow.complete();
        }
        catch (ConcurrentEntityModificationException e) {
        }
        catch (UnitOfWorkCompletionException e) {
            // empty catch block
        }
    }

    @Override
    public void debug(Composite composite, String message, Serializable param1) {
        UnitOfWork uow = this.uowf.newUnitOfWork();
        try {
            ArrayList<Serializable> paramsList = new ArrayList<Serializable>();
            paramsList.add(param1);
            this.createDebugRecord(uow, composite, message, paramsList);
            uow.complete();
        }
        catch (ConcurrentEntityModificationException e) {
        }
        catch (UnitOfWorkCompletionException e) {
            // empty catch block
        }
    }

    @Override
    public void debug(Composite composite, String message, Serializable param1, Serializable param2) {
        UnitOfWork uow = this.uowf.newUnitOfWork();
        try {
            ArrayList<Serializable> paramsList = new ArrayList<Serializable>();
            paramsList.add(param1);
            paramsList.add(param2);
            this.createDebugRecord(uow, composite, message, paramsList);
            uow.complete();
        }
        catch (ConcurrentEntityModificationException e) {
        }
        catch (UnitOfWorkCompletionException e) {
            // empty catch block
        }
    }

    @Override
    public void debug(Composite composite, String message, Serializable ... params) {
        UnitOfWork uow = this.uowf.newUnitOfWork();
        try {
            ArrayList<Serializable> paramsList = new ArrayList<Serializable>(Arrays.asList(params));
            this.createDebugRecord(uow, composite, message, paramsList);
            uow.complete();
        }
        catch (ConcurrentEntityModificationException e) {
        }
        catch (UnitOfWorkCompletionException e) {
            // empty catch block
        }
    }

    private void createDebugRecord(UnitOfWork uow, Composite composite, String message, List<Serializable> params) {
        if (composite instanceof ServiceComposite) {
            EntityBuilder builder = uow.newEntityBuilder(ServiceDebugRecordEntity.class);
            ServiceDebugRecordEntity state = (ServiceDebugRecordEntity)builder.instance();
            this.setStandardStuff(composite, message, state, params);
            state.source().set(((ServiceComposite)composite).identity().get());
            ServiceDebugRecordEntity slr = (ServiceDebugRecordEntity)builder.newInstance();
        } else if (composite instanceof EntityComposite) {
            EntityBuilder builder = uow.newEntityBuilder(EntityDebugRecordEntity.class);
            EntityDebugRecordEntity state = (EntityDebugRecordEntity)builder.instance();
            this.setStandardStuff(composite, message, state, params);
            state.source().set((Object)((EntityComposite)composite));
            EntityDebugRecordEntity elr = (EntityDebugRecordEntity)builder.newInstance();
        } else {
            EntityBuilder builder = uow.newEntityBuilder(CompositeDebugRecordEntity.class);
            CompositeDebugRecordEntity state = (CompositeDebugRecordEntity)builder.instance();
            this.setStandardStuff(composite, message, state, params);
            state.source().set((Object)composite);
            CompositeDebugRecordEntity clr = (CompositeDebugRecordEntity)builder.newInstance();
        }
    }

    private void setStandardStuff(Composite composite, String message, DebugRecord state, List<Serializable> params) {
        state.time().set((Object)System.currentTimeMillis());
        state.message().set((Object)message);
        state.compositeTypeName().set((Object)this.getCompositeName(composite));
        state.threadName().set((Object)Thread.currentThread().getName());
        state.parameters().set(params);
    }

    private String getCompositeName(Composite composite) {
        return ((Class)Iterables.first((Iterable)((CompositeDescriptor)Qi4j.FUNCTION_DESCRIPTOR_FOR.map((Object)composite)).types())).getName();
    }
}

