/*
 * Decompiled with CFR 0.152.
 */
package org.qi4j.logging.log.service;

import java.io.PrintStream;
import java.lang.reflect.Method;
import java.text.MessageFormat;
import java.util.ResourceBundle;
import org.qi4j.api.Qi4j;
import org.qi4j.api.composite.Composite;
import org.qi4j.api.composite.CompositeDescriptor;
import org.qi4j.api.injection.scope.Invocation;
import org.qi4j.api.sideeffect.SideEffectOf;
import org.qi4j.functional.Iterables;
import org.qi4j.logging.log.LogType;
import org.qi4j.logging.log.service.LoggingService;

public abstract class LogOnConsoleSideEffect
extends SideEffectOf<LoggingService>
implements LoggingService {
    private static PrintStream OUT = System.err;
    private final ResourceBundle bundle;

    public LogOnConsoleSideEffect(@Invocation Method thisMethod) {
        this.bundle = ResourceBundle.getBundle(thisMethod.getDeclaringClass().getName());
    }

    public void log(LogType type, Composite composite, String category, String message) {
        String localized = this.bundle.getString(message);
        String logType = type.name();
        OUT.println(logType + ":" + category + ":" + this.getCompositeName(composite) + ": " + localized);
    }

    private String getCompositeName(Composite composite) {
        return ((Class)Iterables.first((Iterable)((CompositeDescriptor)Qi4j.FUNCTION_DESCRIPTOR_FOR.map((Object)composite)).types())).getName();
    }

    public void log(LogType type, Composite composite, String category, String message, Object param1) {
        String localized = this.bundle.getString(message);
        String formatted = MessageFormat.format(localized, param1);
        String logType = type.name();
        OUT.println(logType + ":" + category + ":" + this.getCompositeName(composite) + ": " + formatted);
    }

    public void log(LogType type, Composite composite, String category, String message, Object param1, Object param2) {
        String localized = this.bundle.getString(message);
        String formatted = MessageFormat.format(localized, param1, param2);
        String logtype = type.name();
        OUT.println(logtype + ":" + category + ":" + this.getCompositeName(composite) + ": " + formatted);
    }

    public void log(LogType type, Composite composite, String category, String message, Object ... params) {
        String localized = this.bundle.getString(message);
        String formatted = MessageFormat.format(localized, params);
        String logType = type.name();
        OUT.println(logType + ":" + category + ":" + this.getCompositeName(composite) + ": " + formatted);
    }
}

