/*
 * Decompiled with CFR 0.152.
 */
package org.qi4j.logging.trace;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import org.qi4j.api.Qi4j;
import org.qi4j.api.common.Optional;
import org.qi4j.api.composite.Composite;
import org.qi4j.api.concern.ConcernOf;
import org.qi4j.api.injection.scope.Service;
import org.qi4j.api.injection.scope.Structure;
import org.qi4j.logging.trace.service.TraceService;

public abstract class AbstractTraceConcern
extends ConcernOf<InvocationHandler>
implements InvocationHandler {
    @Structure
    private Qi4j api;
    @Optional
    @Service
    protected TraceService traceService;
    private Composite thisComposite;
    private Class compositeType;

    public AbstractTraceConcern(Composite thisComposite) {
        this.thisComposite = thisComposite;
        this.compositeType = thisComposite.getClass().getInterfaces()[0];
    }

    @Override
    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        Object result;
        boolean doTrace = this.traceService != null && this.doTrace();
        long entryTime = 0L;
        long timeStamp = 0L;
        try {
            if (doTrace) {
                entryTime = System.currentTimeMillis();
                timeStamp = System.nanoTime();
            }
            result = ((InvocationHandler)this.next).invoke(proxy, method, args);
            if (doTrace) {
                long duration = System.nanoTime() - timeStamp;
                this.traceService.traceSuccess(this.compositeType, (Composite)this.api.dereference((Object)this.thisComposite), method, args, result, entryTime, duration);
            }
        }
        catch (Throwable t) {
            if (doTrace) {
                long duration = System.nanoTime() - timeStamp;
                Composite object = (Composite)this.api.dereference((Object)this.thisComposite);
                this.traceService.traceException(this.compositeType, object, method, args, t, entryTime, duration);
            }
            throw t;
        }
        return result;
    }

    protected boolean doTrace() {
        return true;
    }
}

