/*
 * Decompiled with CFR 0.152.
 */
package org.qi4j.logging.trace;

import java.io.PrintStream;
import java.lang.reflect.Method;
import org.qi4j.api.composite.Composite;
import org.qi4j.api.sideeffect.SideEffectOf;
import org.qi4j.logging.trace.service.TraceService;

public abstract class TraceOnConsoleSideEffect
extends SideEffectOf<TraceService>
implements TraceService {
    private static PrintStream OUT = System.err;

    @Override
    public void traceSuccess(Class compositeType, Composite object, Method method, Object[] args, Object result, long entryTime, long durationNano) {
        StringBuffer buf = new StringBuffer();
        buf.append(durationNano / 1000000L);
        buf.append(" ms: ");
        this.formatMethod(buf, object, compositeType, method, args);
        OUT.println(buf.toString());
        OUT.println(result);
    }

    @Override
    public void traceException(Class compositeType, Composite object, Method method, Object[] args, Throwable t, long entryTime, long durationNano) {
        StringBuffer buf = new StringBuffer();
        buf.append("Exception: ");
        buf.append(durationNano / 1000000L);
        buf.append(" ms: ");
        OUT.println(buf.toString());
        t.printStackTrace(OUT);
    }

    private void formatMethod(StringBuffer buf, Composite object, Class compositeType, Method method, Object[] args) {
        buf.append(compositeType.getClass().getName());
        buf.append(".");
        buf.append(method.getName());
        buf.append("( ");
        if (args != null) {
            boolean first = true;
            for (Object arg : args) {
                if (!first) {
                    buf.append(", ");
                }
                first = false;
                if (arg instanceof String) {
                    buf.append("\"");
                }
                buf.append(arg);
                if (!(arg instanceof String)) continue;
                buf.append("\"");
            }
        }
        buf.append(" )  [ ");
        if (object == null) {
            buf.append("<null>");
        } else {
            buf.append(object.toString());
        }
        buf.append(" ]");
    }
}

