/*
 * Decompiled with CFR 0.152.
 */
package org.qi4j.logging.trace.service;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import org.qi4j.api.Qi4j;
import org.qi4j.api.composite.Composite;
import org.qi4j.api.composite.CompositeDescriptor;
import org.qi4j.api.configuration.Configuration;
import org.qi4j.api.entity.EntityBuilder;
import org.qi4j.api.entity.EntityComposite;
import org.qi4j.api.injection.scope.Structure;
import org.qi4j.api.injection.scope.This;
import org.qi4j.api.service.ServiceComposite;
import org.qi4j.api.unitofwork.ConcurrentEntityModificationException;
import org.qi4j.api.unitofwork.UnitOfWork;
import org.qi4j.api.unitofwork.UnitOfWorkCompletionException;
import org.qi4j.api.unitofwork.UnitOfWorkFactory;
import org.qi4j.functional.Iterables;
import org.qi4j.logging.trace.records.CompositeTraceRecordEntity;
import org.qi4j.logging.trace.records.EntityTraceRecordEntity;
import org.qi4j.logging.trace.records.ServiceTraceRecordEntity;
import org.qi4j.logging.trace.records.TraceRecord;
import org.qi4j.logging.trace.service.TraceService;
import org.qi4j.logging.trace.service.TraceServiceConfiguration;

public class TraceServiceMixin
implements TraceService {
    @Structure
    private UnitOfWorkFactory uowf;
    @This
    private Configuration<TraceServiceConfiguration> configuration;
    private int counter;
    private Integer traceLevel;

    @Override
    public int traceLevel() {
        if (this.counter++ % 100 == 0) {
            this.counter = 0;
            this.traceLevel = (Integer)((TraceServiceConfiguration)this.configuration.get()).traceLevel().get();
        }
        return this.traceLevel;
    }

    @Override
    public void traceSuccess(Class compositeType, Composite object, Method method, Object[] args, Object result, long entryTime, long durationNano) {
        UnitOfWork uow = this.uowf.newUnitOfWork();
        try {
            this.createTraceRecord(uow, compositeType, object, method, args, entryTime, durationNano, null);
            uow.complete();
        }
        catch (ConcurrentEntityModificationException e) {
        }
        catch (UnitOfWorkCompletionException e) {
            // empty catch block
        }
    }

    @Override
    public void traceException(Class compositeType, Composite object, Method method, Object[] args, Throwable t, long entryTime, long durationNano) {
        UnitOfWork uow = this.uowf.newUnitOfWork();
        try {
            this.createTraceRecord(uow, compositeType, object, method, args, entryTime, durationNano, t);
            uow.complete();
        }
        catch (ConcurrentEntityModificationException e) {
        }
        catch (UnitOfWorkCompletionException e) {
            // empty catch block
        }
    }

    private void createTraceRecord(UnitOfWork uow, Class compositeType, Composite object, Method method, Object[] args, long entryTime, long durationNano, Throwable exception) {
        if (object instanceof EntityComposite) {
            EntityComposite entity = (EntityComposite)object;
            String identity = (String)entity.identity().get();
            EntityComposite source = (EntityComposite)uow.get((Class)Iterables.first((Iterable)((CompositeDescriptor)Qi4j.FUNCTION_DESCRIPTOR_FOR.map((Object)entity)).types()), identity);
            EntityBuilder builder = uow.newEntityBuilder(EntityTraceRecordEntity.class);
            EntityTraceRecordEntity state = (EntityTraceRecordEntity)builder.instance();
            this.setStandardStuff(compositeType, method, args, entryTime, durationNano, state, exception);
            state.source().set((Object)source);
            EntityTraceRecordEntity etr = (EntityTraceRecordEntity)builder.newInstance();
        } else if (object instanceof ServiceComposite) {
            ServiceComposite service = (ServiceComposite)object;
            EntityBuilder builder = uow.newEntityBuilder(ServiceTraceRecordEntity.class);
            ServiceTraceRecordEntity state = (ServiceTraceRecordEntity)builder.instance();
            this.setStandardStuff(compositeType, method, args, entryTime, durationNano, state, exception);
            state.source().set((Object)service.toString());
            ServiceTraceRecordEntity str = (ServiceTraceRecordEntity)builder.newInstance();
        } else {
            EntityBuilder builder = uow.newEntityBuilder(CompositeTraceRecordEntity.class);
            CompositeTraceRecordEntity state = (CompositeTraceRecordEntity)builder.instance();
            state.source().set((Object)object);
            this.setStandardStuff(compositeType, method, args, entryTime, durationNano, state, exception);
            CompositeTraceRecordEntity ctr = (CompositeTraceRecordEntity)builder.newInstance();
        }
    }

    private void setStandardStuff(Class compositeType, Method method, Object[] args, long entryTime, long durationNano, TraceRecord state, Throwable exception) {
        state.duration().set((Object)durationNano);
        state.entryTime().set((Object)entryTime);
        state.methodName().set((Object)method.getName());
        state.compositeTypeName().set((Object)compositeType.getName());
        state.arguments().set(this.convertArguments(args));
        state.threadName().set((Object)Thread.currentThread().getName());
        state.exception().set((Object)exception);
    }

    private List<String> convertArguments(Object[] args) {
        if (args == null) {
            return new ArrayList<String>(0);
        }
        ArrayList<String> result = new ArrayList<String>(args.length);
        for (Object arg : args) {
            if (arg == null) {
                result.add(null);
                continue;
            }
            result.add(arg.toString());
        }
        return result;
    }
}

