/*
 * Decompiled with CFR 0.152.
 */
package org.qi4j.api.common;

import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Type;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;
import org.qi4j.api.concern.Concerns;
import org.qi4j.api.mixin.Mixins;
import org.qi4j.api.sideeffect.SideEffects;
import org.qi4j.api.util.Classes;

public final class MetaInfo {
    private static final Collection<Class> ignored = new HashSet<Class>(4, 0.8f);
    private final Map<Class<?>, Object> metaInfoMap = new LinkedHashMap();

    public MetaInfo() {
    }

    public MetaInfo(MetaInfo metaInfo) {
        this.metaInfoMap.putAll(metaInfo.metaInfoMap);
    }

    public void set(Object metaInfo) {
        if (metaInfo instanceof Annotation) {
            Annotation annotation = (Annotation)metaInfo;
            this.metaInfoMap.put(annotation.annotationType(), metaInfo);
        } else {
            Class<?> metaInfoclass = metaInfo.getClass();
            Iterable<Type> types = Classes.typesOf(metaInfoclass);
            for (Type type : types) {
                this.metaInfoMap.put((Class<?>)Classes.RAW_CLASS.map((Object)type), metaInfo);
            }
        }
    }

    public <T> T get(Class<T> metaInfoType) {
        return metaInfoType.cast(this.metaInfoMap.get(metaInfoType));
    }

    public <T> void add(Class<T> infoType, T info) {
        this.metaInfoMap.put(infoType, info);
    }

    public MetaInfo withAnnotations(AnnotatedElement annotatedElement) {
        for (Annotation annotation : annotatedElement.getAnnotations()) {
            if (ignored.contains(annotation.annotationType()) || this.get(annotation.annotationType()) != null) continue;
            this.set(annotation);
        }
        return this;
    }

    public String toString() {
        return this.metaInfoMap.toString();
    }

    public void remove(Class serviceFinderClass) {
        this.metaInfoMap.remove(serviceFinderClass);
    }

    static {
        ignored.addAll(Arrays.asList(Mixins.class, Concerns.class, SideEffects.class));
    }
}

