/*
 * Decompiled with CFR 0.152.
 */
package org.qi4j.api.composite;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import org.qi4j.api.injection.scope.Uses;

public class DecoratorMixin
implements InvocationHandler {
    private Object delegate;

    public DecoratorMixin(@Uses Object delegate) {
        if (delegate instanceof Class) {
            Thread.dumpStack();
        }
        this.delegate = delegate;
    }

    @Override
    public Object invoke(Object object, Method method, Object[] args) throws Throwable {
        if (this.delegate instanceof InvocationHandler) {
            InvocationHandler handler = (InvocationHandler)this.delegate;
            return handler.invoke(object, method, args);
        }
        try {
            return method.invoke(this.delegate, args);
        }
        catch (InvocationTargetException e) {
            throw e.getCause();
        }
        catch (IllegalArgumentException e) {
            String message = this.constructMessage(method, args);
            throw new IllegalArgumentException(message, e);
        }
    }

    private String constructMessage(Method method, Object[] args) {
        StringBuilder builder = new StringBuilder();
        builder.append("\nmethod: ");
        builder.append(method.getDeclaringClass().getName());
        builder.append(".");
        builder.append(method.getName());
        builder.append("\ndelegate: ");
        builder.append(this.delegate);
        builder.append("\ndelegateType: ");
        builder.append(this.delegate == null ? "n/a" : this.delegate.getClass().getName());
        builder.append("\narguments: \n");
        for (Object arg : args) {
            builder.append("    ");
            Class<?> argClass = arg.getClass();
            if (Proxy.isProxyClass(argClass)) {
                builder.append(Proxy.getInvocationHandler(arg).getClass().getName());
            } else {
                builder.append(argClass.getName());
            }
            builder.append('\n');
        }
        return builder.toString();
    }
}

