/*
 * Decompiled with CFR 0.152.
 */
package org.qi4j.api.dataset.iterable;

import java.util.HashMap;
import java.util.Map;
import org.qi4j.api.dataset.Query;
import org.qi4j.api.property.Property;
import org.qi4j.api.query.QueryException;
import org.qi4j.functional.Iterables;
import org.qi4j.functional.Specification;
import org.qi4j.functional.Visitor;

public class IterableQuery<T>
implements Query<T> {
    private Iterable<T> iterable;
    private int skip;
    private int limit;
    private Map<String, Object> variables = new HashMap<String, Object>();

    public IterableQuery(Iterable<T> iterable) {
        this.iterable = iterable;
    }

    @Override
    public Query filter(Specification<T> filter) {
        this.iterable = Iterables.filter(filter, this.iterable);
        return this;
    }

    @Override
    public Query orderBy(Property<?> property, Query.Order order) {
        return this;
    }

    @Override
    public Query skip(int skipNrOfResults) {
        this.skip = skipNrOfResults;
        return this;
    }

    @Override
    public Query limit(int maxNrOfResults) {
        this.limit = maxNrOfResults;
        return this;
    }

    @Override
    public Query<T> setVariable(String name, Object value) {
        this.variables.put(name, value);
        return this;
    }

    @Override
    public Object getVariable(String name) {
        return this.variables.get(name);
    }

    @Override
    public long count() {
        return Iterables.count((Iterable)Iterables.limit((int)this.limit, (Iterable)Iterables.skip((int)this.skip, this.iterable)));
    }

    @Override
    public T first() {
        return (T)Iterables.first((Iterable)Iterables.limit((int)this.limit, (Iterable)Iterables.skip((int)this.skip, this.iterable)));
    }

    @Override
    public T single() throws QueryException {
        return (T)Iterables.single((Iterable)Iterables.limit((int)this.limit, (Iterable)Iterables.skip((int)this.skip, this.iterable)));
    }

    @Override
    public <ThrowableType extends Throwable> boolean execute(Visitor<T, ThrowableType> resultVisitor) throws ThrowableType {
        for (T t : this.toIterable()) {
            if (resultVisitor.visit(t)) continue;
            return false;
        }
        return true;
    }

    @Override
    public Iterable<T> toIterable() throws QueryException {
        return Iterables.limit((int)this.limit, (Iterable)Iterables.skip((int)this.skip, this.iterable));
    }
}

