/*
 * Decompiled with CFR 0.152.
 */
package org.qi4j.api.entity;

import java.io.Serializable;
import org.qi4j.api.entity.EntityComposite;
import org.qi4j.api.entity.Identity;
import org.qi4j.api.util.NullArgumentException;

public final class EntityReference
implements Serializable {
    private static final long serialVersionUID = 1L;
    private String identity;

    public static EntityReference parseURI(String uri) {
        String identity = uri.substring("urn:qi4j:entity:".length());
        return new EntityReference(identity);
    }

    public static EntityReference parseEntityReference(String identity) {
        return new EntityReference(identity);
    }

    public static EntityReference entityReferenceFor(Object object) {
        return new EntityReference((EntityComposite)object);
    }

    public static EntityReference create(Identity identity) {
        if (identity == null) {
            return null;
        }
        return new EntityReference(identity.identity().get());
    }

    public EntityReference(EntityComposite entityComposite) {
        this(entityComposite.identity().get());
    }

    public EntityReference(String identity) {
        NullArgumentException.validateNotEmpty("identity", identity);
        this.identity = identity;
    }

    public final String identity() {
        return this.identity;
    }

    public String toURI() {
        return "urn:qi4j:entity:" + this.identity;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        EntityReference that = (EntityReference)o;
        return this.identity.equals(that.identity);
    }

    public int hashCode() {
        return this.identity.hashCode();
    }

    public String toString() {
        return this.identity;
    }
}

