/*
 * Decompiled with CFR 0.152.
 */
package org.qi4j.api.mixin;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;

public final class NoopMixin
implements InvocationHandler {
    private static final Boolean BOOLEAN_DEFAULT = Boolean.FALSE;
    private static final Short SHORT_DEFAULT = 0;
    private static final Character CHARACTER_DEFAULT = Character.valueOf('\u0000');
    private static final Integer INTEGER_DEFAULT = 0;
    private static final Long LONG_DEFAULT = 0L;
    private static final Float FLOAT_DEFAULT = Float.valueOf(0.0f);
    private static final Double DOUBLE_DEFAULT = 0.0;

    @Override
    public Object invoke(Object object, Method method, Object[] args) throws Throwable {
        Class<?> retType = method.getReturnType();
        if (!retType.isPrimitive()) {
            return null;
        }
        if (Void.TYPE == retType) {
            return null;
        }
        if (Boolean.TYPE == retType) {
            return BOOLEAN_DEFAULT;
        }
        if (Short.TYPE == retType) {
            return SHORT_DEFAULT;
        }
        if (Character.TYPE == retType) {
            return CHARACTER_DEFAULT;
        }
        if (Integer.TYPE == retType) {
            return INTEGER_DEFAULT;
        }
        if (Long.TYPE == retType) {
            return LONG_DEFAULT;
        }
        if (Float.TYPE == retType) {
            return FLOAT_DEFAULT;
        }
        if (Double.TYPE == retType) {
            return DOUBLE_DEFAULT;
        }
        return null;
    }
}

