/*
 * Decompiled with CFR 0.152.
 */
package org.qi4j.api.query;

import java.lang.reflect.Field;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.lang.reflect.Type;
import java.util.Arrays;
import java.util.Collection;
import org.qi4j.api.association.Association;
import org.qi4j.api.association.GenericAssociationInfo;
import org.qi4j.api.association.ManyAssociation;
import org.qi4j.api.association.NamedAssociation;
import org.qi4j.api.composite.Composite;
import org.qi4j.api.entity.Identity;
import org.qi4j.api.injection.scope.State;
import org.qi4j.api.property.GenericPropertyInfo;
import org.qi4j.api.property.Property;
import org.qi4j.api.query.grammar.AndSpecification;
import org.qi4j.api.query.grammar.AssociationFunction;
import org.qi4j.api.query.grammar.AssociationNotNullSpecification;
import org.qi4j.api.query.grammar.AssociationNullSpecification;
import org.qi4j.api.query.grammar.ContainsAllSpecification;
import org.qi4j.api.query.grammar.ContainsSpecification;
import org.qi4j.api.query.grammar.EqSpecification;
import org.qi4j.api.query.grammar.GeSpecification;
import org.qi4j.api.query.grammar.GtSpecification;
import org.qi4j.api.query.grammar.LeSpecification;
import org.qi4j.api.query.grammar.LtSpecification;
import org.qi4j.api.query.grammar.ManyAssociationContainsSpecification;
import org.qi4j.api.query.grammar.ManyAssociationFunction;
import org.qi4j.api.query.grammar.MatchesSpecification;
import org.qi4j.api.query.grammar.NamedAssociationContainsNameSpecification;
import org.qi4j.api.query.grammar.NamedAssociationContainsSpecification;
import org.qi4j.api.query.grammar.NamedAssociationFunction;
import org.qi4j.api.query.grammar.NeSpecification;
import org.qi4j.api.query.grammar.NotSpecification;
import org.qi4j.api.query.grammar.OrSpecification;
import org.qi4j.api.query.grammar.OrderBy;
import org.qi4j.api.query.grammar.PropertyFunction;
import org.qi4j.api.query.grammar.PropertyNotNullSpecification;
import org.qi4j.api.query.grammar.PropertyNullSpecification;
import org.qi4j.api.query.grammar.PropertyReference;
import org.qi4j.api.query.grammar.Variable;
import org.qi4j.api.util.NullArgumentException;
import org.qi4j.functional.Iterables;
import org.qi4j.functional.Specification;

public final class QueryExpressions {
    private static final Method IDENTITY_METHOD;

    public static <T> T templateFor(Class<T> clazz) {
        NullArgumentException.validateNotNull("Template class", clazz);
        if (clazz.isInterface()) {
            return clazz.cast(Proxy.newProxyInstance(clazz.getClassLoader(), QueryExpressions.array(clazz), new TemplateHandler(null, null, null, null)));
        }
        try {
            T mixin = clazz.newInstance();
            for (Field field : clazz.getFields()) {
                if (field.getAnnotation(State.class) == null) continue;
                if (field.getType().equals(Property.class)) {
                    field.set(mixin, Proxy.newProxyInstance(field.getType().getClassLoader(), QueryExpressions.array(field.getType()), new PropertyReferenceHandler(new PropertyFunction(null, null, null, null, field))));
                    continue;
                }
                if (field.getType().equals(Association.class)) {
                    field.set(mixin, Proxy.newProxyInstance(field.getType().getClassLoader(), QueryExpressions.array(field.getType()), new AssociationReferenceHandler(new AssociationFunction(null, null, null, field))));
                    continue;
                }
                if (field.getType().equals(ManyAssociation.class)) {
                    field.set(mixin, Proxy.newProxyInstance(field.getType().getClassLoader(), QueryExpressions.array(field.getType()), new ManyAssociationReferenceHandler(new ManyAssociationFunction(null, null, null, field))));
                    continue;
                }
                if (!field.getType().equals(NamedAssociation.class)) continue;
                field.set(mixin, Proxy.newProxyInstance(field.getType().getClassLoader(), QueryExpressions.array(field.getType()), new NamedAssociationReferenceHandler(new NamedAssociationFunction(null, null, null, field))));
            }
            return mixin;
        }
        catch (IllegalAccessException | IllegalArgumentException | InstantiationException | SecurityException e) {
            throw new IllegalArgumentException("Cannot use class as template", e);
        }
    }

    public static <T> T templateFor(Class<T> mixinType, Association<?> association) {
        NullArgumentException.validateNotNull("Mixin class", mixinType);
        NullArgumentException.validateNotNull("Association", association);
        return mixinType.cast(Proxy.newProxyInstance(mixinType.getClassLoader(), QueryExpressions.array(mixinType), new TemplateHandler(null, QueryExpressions.association(association), null, null)));
    }

    public static <T> T oneOf(ManyAssociation<T> association) {
        NullArgumentException.validateNotNull("Association", association);
        return association.get(0);
    }

    public static <T> T oneOf(NamedAssociation<T> association) {
        NullArgumentException.validateNotNull("Association", association);
        return association.get((String)Iterables.first(association));
    }

    public static Variable variable(String name) {
        NullArgumentException.validateNotNull("Variable name", name);
        return new Variable(name);
    }

    public static <T> PropertyFunction<T> property(Property<T> property) {
        return ((PropertyReferenceHandler)Proxy.getInvocationHandler(property)).property();
    }

    public static <T> Property<T> property(Class<?> mixinClass, String fieldName) {
        try {
            Field field = mixinClass.getField(fieldName);
            if (!Property.class.isAssignableFrom(field.getType())) {
                throw new IllegalArgumentException("Field must be of type Property<?>");
            }
            return (Property)Proxy.newProxyInstance(mixinClass.getClassLoader(), QueryExpressions.array(field.getType()), new PropertyReferenceHandler(new PropertyFunction(null, null, null, null, field)));
        }
        catch (NoSuchFieldException e) {
            throw new IllegalArgumentException("No such field '" + fieldName + "' in mixin " + mixinClass.getName());
        }
    }

    public static <T> AssociationFunction<T> association(Association<T> association) {
        return ((AssociationReferenceHandler)Proxy.getInvocationHandler(association)).association();
    }

    public static <T> ManyAssociationFunction<T> manyAssociation(ManyAssociation<T> association) {
        return ((ManyAssociationReferenceHandler)Proxy.getInvocationHandler(association)).manyAssociation();
    }

    public static <T> NamedAssociationFunction<T> namedAssociation(NamedAssociation<T> association) {
        return ((NamedAssociationReferenceHandler)Proxy.getInvocationHandler(association)).namedAssociation();
    }

    @SafeVarargs
    public static AndSpecification and(Specification<Composite> left, Specification<Composite> right, Specification<Composite> ... optionalRight) {
        return new AndSpecification(Iterables.prepend(left, (Iterable)Iterables.prepend(right, Arrays.asList(optionalRight))));
    }

    @SafeVarargs
    public static OrSpecification or(Specification<Composite> ... specs) {
        return new OrSpecification(Arrays.asList(specs));
    }

    public static NotSpecification not(Specification<Composite> operand) {
        return new NotSpecification(operand);
    }

    public static <T> EqSpecification<T> eq(Property<T> property, T value) {
        return new EqSpecification<T>(QueryExpressions.property(property), value);
    }

    public static <T> EqSpecification<T> eq(Property<T> property, Variable variable) {
        return new EqSpecification<Variable>(QueryExpressions.property(property), variable);
    }

    public static <T> EqSpecification<String> eq(Association<T> association, T value) {
        return new EqSpecification<String>(new PropertyFunction(null, QueryExpressions.association(association), null, null, IDENTITY_METHOD), value.toString());
    }

    public static <T> GeSpecification<T> ge(Property<T> property, T value) {
        return new GeSpecification<T>(QueryExpressions.property(property), value);
    }

    public static <T> GeSpecification<T> ge(Property<T> property, Variable variable) {
        return new GeSpecification<Variable>(QueryExpressions.property(property), variable);
    }

    public static <T> GtSpecification<T> gt(Property<T> property, T value) {
        return new GtSpecification<T>(QueryExpressions.property(property), value);
    }

    public static <T> GtSpecification<T> gt(Property<T> property, Variable variable) {
        return new GtSpecification<Variable>(QueryExpressions.property(property), variable);
    }

    public static <T> LeSpecification<T> le(Property<T> property, T value) {
        return new LeSpecification<T>(QueryExpressions.property(property), value);
    }

    public static <T> LeSpecification<T> le(Property<T> property, Variable variable) {
        return new LeSpecification<Variable>(QueryExpressions.property(property), variable);
    }

    public static <T> LtSpecification<T> lt(Property<T> property, T value) {
        return new LtSpecification<T>(QueryExpressions.property(property), value);
    }

    public static <T> LtSpecification<T> lt(Property<T> property, Variable variable) {
        return new LtSpecification<Variable>(QueryExpressions.property(property), variable);
    }

    public static <T> NeSpecification<T> ne(Property<T> property, T value) {
        return new NeSpecification<T>(QueryExpressions.property(property), value);
    }

    public static <T> NeSpecification<T> ne(Property<T> property, Variable variable) {
        return new NeSpecification<Variable>(QueryExpressions.property(property), variable);
    }

    public static MatchesSpecification matches(Property<String> property, String regexp) {
        return new MatchesSpecification(QueryExpressions.property(property), regexp);
    }

    public static MatchesSpecification matches(Property<String> property, Variable variable) {
        return new MatchesSpecification(QueryExpressions.property(property), variable);
    }

    public static <T> PropertyNotNullSpecification<T> isNotNull(Property<T> property) {
        return new PropertyNotNullSpecification<T>(QueryExpressions.property(property));
    }

    public static <T> PropertyNullSpecification<T> isNull(Property<T> property) {
        return new PropertyNullSpecification<T>(QueryExpressions.property(property));
    }

    public static <T> AssociationNotNullSpecification<T> isNotNull(Association<T> association) {
        return new AssociationNotNullSpecification<T>(QueryExpressions.association(association));
    }

    public static <T> AssociationNullSpecification<T> isNull(Association<T> association) {
        return new AssociationNullSpecification<T>(QueryExpressions.association(association));
    }

    public static <T> ContainsAllSpecification<T> containsAll(Property<? extends Collection<T>> collectionProperty, Iterable<T> values) {
        NullArgumentException.validateNotNull("Values", values);
        return new ContainsAllSpecification<T>(QueryExpressions.property(collectionProperty), values);
    }

    public static <T> ContainsAllSpecification<T> containsAllVariables(Property<? extends Collection<T>> collectionProperty, Iterable<Variable> variables) {
        NullArgumentException.validateNotNull("Variables", variables);
        return new ContainsAllSpecification<Variable>(QueryExpressions.property(collectionProperty), variables);
    }

    public static <T> ContainsSpecification<T> contains(Property<? extends Collection<T>> collectionProperty, T value) {
        NullArgumentException.validateNotNull("Value", value);
        return new ContainsSpecification<T>(QueryExpressions.property(collectionProperty), value);
    }

    public static <T> ContainsSpecification<T> contains(Property<? extends Collection<T>> collectionProperty, Variable variable) {
        NullArgumentException.validateNotNull("Variable", variable);
        return new ContainsSpecification<Variable>(QueryExpressions.property(collectionProperty), variable);
    }

    public static <T> ManyAssociationContainsSpecification<T> contains(ManyAssociation<T> manyAssoc, T value) {
        return new ManyAssociationContainsSpecification<T>(QueryExpressions.manyAssociation(manyAssoc), value);
    }

    public static <T> NamedAssociationContainsSpecification<T> contains(NamedAssociation<T> namedAssoc, T value) {
        return new NamedAssociationContainsSpecification<T>(QueryExpressions.namedAssociation(namedAssoc), value);
    }

    public static <T> NamedAssociationContainsNameSpecification<T> containsName(NamedAssociation<T> namedAssoc, String name) {
        return new NamedAssociationContainsNameSpecification<T>(QueryExpressions.namedAssociation(namedAssoc), name);
    }

    public static <T> OrderBy orderBy(Property<T> property) {
        return QueryExpressions.orderBy(property, OrderBy.Order.ASCENDING);
    }

    public static <T> OrderBy orderBy(Property<T> property, OrderBy.Order order) {
        return new OrderBy(QueryExpressions.property(property), order);
    }

    @SafeVarargs
    private static <T> T[] array(T ... array) {
        return array;
    }

    private QueryExpressions() {
    }

    static {
        try {
            IDENTITY_METHOD = Identity.class.getMethod("identity", new Class[0]);
        }
        catch (NoSuchMethodException e) {
            throw new InternalError("Zest Core API codebase is corrupted. Contact Zest team: QueryExpressions");
        }
    }

    private static class NamedAssociationReferenceHandler<T>
    implements InvocationHandler {
        private final NamedAssociationFunction<T> namedAssociation;

        private NamedAssociationReferenceHandler(NamedAssociationFunction<T> namedAssociation) {
            this.namedAssociation = namedAssociation;
        }

        public NamedAssociationFunction<T> namedAssociation() {
            return this.namedAssociation;
        }

        @Override
        public Object invoke(Object o, Method method, Object[] objects) throws Throwable {
            Type namedAssociationType;
            if (method.equals(NamedAssociation.class.getMethod("get", String.class)) && (namedAssociationType = GenericAssociationInfo.associationTypeOf(this.namedAssociation.accessor())).getClass().equals(Class.class)) {
                return Proxy.newProxyInstance(method.getDeclaringClass().getClassLoader(), (Class[])QueryExpressions.array(new Class[]{(Class)namedAssociationType, PropertyReference.class}), new TemplateHandler(null, null, null, this.namedAssociation));
            }
            return null;
        }
    }

    private static class ManyAssociationReferenceHandler<T>
    implements InvocationHandler {
        private final ManyAssociationFunction<T> manyAssociation;

        private ManyAssociationReferenceHandler(ManyAssociationFunction<T> manyAssociation) {
            this.manyAssociation = manyAssociation;
        }

        public ManyAssociationFunction<T> manyAssociation() {
            return this.manyAssociation;
        }

        @Override
        public Object invoke(Object o, Method method, Object[] objects) throws Throwable {
            Type manyAssociationType;
            if (method.equals(ManyAssociation.class.getMethod("get", Integer.TYPE)) && (manyAssociationType = GenericAssociationInfo.associationTypeOf(this.manyAssociation.accessor())).getClass().equals(Class.class)) {
                return Proxy.newProxyInstance(method.getDeclaringClass().getClassLoader(), (Class[])QueryExpressions.array(new Class[]{(Class)manyAssociationType, PropertyReference.class}), new TemplateHandler(null, null, this.manyAssociation, null));
            }
            return null;
        }
    }

    private static class AssociationReferenceHandler<T>
    implements InvocationHandler {
        private final AssociationFunction<T> association;

        private AssociationReferenceHandler(AssociationFunction<T> association) {
            this.association = association;
        }

        private AssociationFunction<T> association() {
            return this.association;
        }

        @Override
        public Object invoke(Object o, Method method, Object[] objects) throws Throwable {
            Type associationType;
            if (method.equals(Association.class.getMethod("get", new Class[0])) && (associationType = GenericAssociationInfo.associationTypeOf(this.association.accessor())).getClass().equals(Class.class)) {
                return Proxy.newProxyInstance(method.getDeclaringClass().getClassLoader(), (Class[])QueryExpressions.array(new Class[]{(Class)associationType, PropertyReference.class}), new TemplateHandler(null, this.association, null, null));
            }
            return null;
        }
    }

    private static class PropertyReferenceHandler<T>
    implements InvocationHandler {
        private final PropertyFunction<T> property;

        private PropertyReferenceHandler(PropertyFunction<T> property) {
            this.property = property;
        }

        private PropertyFunction<T> property() {
            return this.property;
        }

        @Override
        public Object invoke(Object o, Method method, Object[] objects) throws Throwable {
            Type propertyType;
            if (method.equals(Property.class.getMethod("get", new Class[0])) && (propertyType = GenericPropertyInfo.propertyTypeOf(this.property.accessor())).getClass().equals(Class.class)) {
                return Proxy.newProxyInstance(method.getDeclaringClass().getClassLoader(), (Class[])QueryExpressions.array(new Class[]{(Class)propertyType, PropertyReference.class}), new TemplateHandler(this.property, null, null, null));
            }
            return null;
        }
    }

    private static class TemplateHandler<T>
    implements InvocationHandler {
        private final PropertyFunction<?> compositeProperty;
        private final AssociationFunction<?> compositeAssociation;
        private final ManyAssociationFunction<?> compositeManyAssociation;
        private final NamedAssociationFunction<?> compositeNamedAssociation;

        private TemplateHandler(PropertyFunction<?> compositeProperty, AssociationFunction<?> compositeAssociation, ManyAssociationFunction<?> compositeManyAssociation, NamedAssociationFunction<?> compositeNamedAssociation) {
            this.compositeProperty = compositeProperty;
            this.compositeAssociation = compositeAssociation;
            this.compositeManyAssociation = compositeManyAssociation;
            this.compositeNamedAssociation = compositeNamedAssociation;
        }

        @Override
        public Object invoke(Object o, Method method, Object[] objects) throws Throwable {
            if (Property.class.isAssignableFrom(method.getReturnType())) {
                return Proxy.newProxyInstance(method.getReturnType().getClassLoader(), (Class[])QueryExpressions.array(new Class[]{method.getReturnType()}), new PropertyReferenceHandler(new PropertyFunction(this.compositeProperty, this.compositeAssociation, this.compositeManyAssociation, this.compositeNamedAssociation, method)));
            }
            if (Association.class.isAssignableFrom(method.getReturnType())) {
                return Proxy.newProxyInstance(method.getReturnType().getClassLoader(), (Class[])QueryExpressions.array(new Class[]{method.getReturnType()}), new AssociationReferenceHandler(new AssociationFunction(this.compositeAssociation, this.compositeManyAssociation, this.compositeNamedAssociation, method)));
            }
            if (ManyAssociation.class.isAssignableFrom(method.getReturnType())) {
                return Proxy.newProxyInstance(method.getReturnType().getClassLoader(), (Class[])QueryExpressions.array(new Class[]{method.getReturnType()}), new ManyAssociationReferenceHandler(new ManyAssociationFunction(this.compositeAssociation, this.compositeManyAssociation, this.compositeNamedAssociation, method)));
            }
            if (NamedAssociation.class.isAssignableFrom(method.getReturnType())) {
                return Proxy.newProxyInstance(method.getReturnType().getClassLoader(), (Class[])QueryExpressions.array(new Class[]{method.getReturnType()}), new NamedAssociationReferenceHandler(new NamedAssociationFunction(this.compositeAssociation, this.compositeManyAssociation, this.compositeNamedAssociation, method)));
            }
            return null;
        }
    }
}

