/*
 * Decompiled with CFR 0.152.
 */
package org.qi4j.api.query.grammar;

import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Member;
import java.lang.reflect.Proxy;
import java.lang.reflect.Type;
import org.qi4j.api.association.Association;
import org.qi4j.api.association.AssociationStateHolder;
import org.qi4j.api.association.GenericAssociationInfo;
import org.qi4j.api.association.ManyAssociation;
import org.qi4j.api.association.NamedAssociation;
import org.qi4j.api.composite.Composite;
import org.qi4j.api.composite.CompositeInstance;
import org.qi4j.api.query.QueryExpressionException;
import org.qi4j.api.query.grammar.ManyAssociationFunction;
import org.qi4j.api.query.grammar.NamedAssociationFunction;
import org.qi4j.api.util.Classes;
import org.qi4j.functional.Function;

public class AssociationFunction<T>
implements Function<Composite, Association<T>> {
    private final AssociationFunction<?> traversedAssociation;
    private final ManyAssociationFunction<?> traversedManyAssociation;
    private final NamedAssociationFunction<?> traversedNamedAssociation;
    private final AccessibleObject accessor;

    public AssociationFunction(AssociationFunction<?> traversedAssociation, ManyAssociationFunction<?> traversedManyAssociation, NamedAssociationFunction<?> traversedNamedAssociation, AccessibleObject accessor) {
        this.traversedAssociation = traversedAssociation;
        this.traversedManyAssociation = traversedManyAssociation;
        this.traversedNamedAssociation = traversedNamedAssociation;
        this.accessor = accessor;
        Type returnType = Classes.typeOf(accessor);
        if (!(Association.class.isAssignableFrom((Class)Classes.RAW_CLASS.map((Object)returnType)) || ManyAssociation.class.isAssignableFrom((Class)Classes.RAW_CLASS.map((Object)returnType)) || NamedAssociation.class.isAssignableFrom((Class)Classes.RAW_CLASS.map((Object)returnType)))) {
            throw new QueryExpressionException("Unsupported association type:" + returnType);
        }
        Type associationTypeAsType = GenericAssociationInfo.toAssociationType(returnType);
        if (!(associationTypeAsType instanceof Class)) {
            throw new QueryExpressionException("Unsupported association type:" + associationTypeAsType);
        }
    }

    public AssociationFunction<?> traversedAssociation() {
        return this.traversedAssociation;
    }

    public ManyAssociationFunction<?> traversedManyAssociation() {
        return this.traversedManyAssociation;
    }

    public NamedAssociationFunction<?> traversedNamedAssociation() {
        return this.traversedNamedAssociation;
    }

    public AccessibleObject accessor() {
        return this.accessor;
    }

    public Association<T> map(Composite entity) {
        try {
            Composite target = entity;
            if (this.traversedAssociation != null) {
                Association<?> association = this.traversedAssociation.map(entity);
                if (association == null) {
                    return null;
                }
                target = association.get();
            } else {
                if (this.traversedManyAssociation != null) {
                    throw new IllegalArgumentException("Cannot evaluate a ManyAssociation");
                }
                if (this.traversedNamedAssociation != null) {
                    throw new IllegalArgumentException("Cannot evaluate a NamedAssociation");
                }
            }
            if (target == null) {
                return null;
            }
            CompositeInstance handler = (CompositeInstance)Proxy.getInvocationHandler(target);
            return ((AssociationStateHolder)handler.state()).associationFor(this.accessor);
        }
        catch (IllegalArgumentException e) {
            throw e;
        }
        catch (Throwable e) {
            throw new IllegalArgumentException(e);
        }
    }

    public String toString() {
        if (this.traversedAssociation != null) {
            return this.traversedAssociation.toString() + "." + ((Member)((Object)this.accessor)).getName();
        }
        return ((Member)((Object)this.accessor)).getName();
    }
}

