/*
 * Decompiled with CFR 0.152.
 */
package org.qi4j.api.query.grammar;

import java.util.Collection;
import org.qi4j.api.composite.Composite;
import org.qi4j.api.query.grammar.ExpressionSpecification;
import org.qi4j.api.query.grammar.PropertyFunction;
import org.qi4j.functional.Iterables;

public class ContainsAllSpecification<T>
extends ExpressionSpecification {
    private PropertyFunction<? extends Collection<T>> collectionProperty;
    private Iterable<T> valueCollection;

    public ContainsAllSpecification(PropertyFunction<? extends Collection<T>> collectionProperty, Iterable<T> valueCollection) {
        this.collectionProperty = collectionProperty;
        this.valueCollection = valueCollection;
    }

    public PropertyFunction<? extends Collection<T>> collectionProperty() {
        return this.collectionProperty;
    }

    public Iterable<T> containedValues() {
        return this.valueCollection;
    }

    public boolean satisfiedBy(Composite item) {
        Collection<T> collection = this.collectionProperty.map(item).get();
        if (collection == null) {
            return false;
        }
        for (T value : this.valueCollection) {
            if (collection.contains(value)) continue;
            return false;
        }
        return true;
    }

    public String toString() {
        return this.collectionProperty + " contains " + Iterables.toList(this.valueCollection);
    }
}

