/*
 * Decompiled with CFR 0.152.
 */
package org.qi4j.api.query.grammar;

import org.qi4j.api.composite.Composite;
import org.qi4j.api.property.Property;
import org.qi4j.api.query.grammar.ExpressionSpecification;
import org.qi4j.api.query.grammar.PropertyFunction;
import org.qi4j.api.query.grammar.Variable;

public class MatchesSpecification
extends ExpressionSpecification {
    private PropertyFunction<String> property;
    private Object value;

    public MatchesSpecification(PropertyFunction<String> property, String regexp) {
        this.property = property;
        this.value = regexp;
    }

    public MatchesSpecification(PropertyFunction<String> property, Variable variable) {
        this.property = property;
        this.value = variable;
    }

    public PropertyFunction<String> property() {
        return this.property;
    }

    public Object value() {
        return this.value;
    }

    public String regexp() {
        return (String)this.value;
    }

    public boolean satisfiedBy(Composite item) {
        Property<String> prop = this.property.map(item);
        if (prop == null) {
            return false;
        }
        String val = prop.get();
        if (val == null) {
            return false;
        }
        return val.matches((String)this.value);
    }

    public String toString() {
        return "( " + this.property + " matches " + "\"" + this.value + "\"" + " )";
    }
}

