/*
 * Decompiled with CFR 0.152.
 */
package org.qi4j.api.type;

import java.util.Collections;
import org.qi4j.api.type.HasTypes;
import org.qi4j.api.util.NullArgumentException;
import org.qi4j.functional.Function;
import org.qi4j.functional.Iterables;

public class ValueType
implements HasTypes {
    protected final Iterable<Class<?>> types;

    public static ValueType of(Class<?> type) {
        return new ValueType(type);
    }

    public static boolean isPrimitiveValue(Object object) {
        NullArgumentException.validateNotNull("object", object);
        if (object instanceof String || object instanceof Character || object instanceof Boolean || object instanceof Integer || object instanceof Double || object instanceof Float || object instanceof Long || object instanceof Byte || object instanceof Short) {
            return true;
        }
        if (object.getClass().isArray()) {
            return ValueType.isArrayOfPrimitiveValues(object);
        }
        return false;
    }

    private static boolean isArrayOfPrimitiveValues(Object array) {
        return array instanceof String[] || array instanceof char[] || array instanceof Character[] || array instanceof boolean[] || array instanceof Boolean[] || array instanceof int[] || array instanceof Integer[] || array instanceof double[] || array instanceof Double[] || array instanceof float[] || array instanceof Float[] || array instanceof long[] || array instanceof Long[] || array instanceof byte[] || array instanceof Byte[] || array instanceof short[] || array instanceof Short[];
    }

    public static boolean isPrimitiveValueType(ValueType valueType) {
        return ValueType.isPrimitiveValueType(valueType.mainType());
    }

    public static boolean isPrimitiveValueType(Class<?> type) {
        NullArgumentException.validateNotNull("type", type);
        if (String.class.isAssignableFrom(type)) {
            return true;
        }
        if (type.isArray()) {
            return ValueType.isPrimitiveValueType(type.getComponentType());
        }
        return false;
    }

    public ValueType(Class<?> type) {
        this(Collections.singleton(type));
    }

    public ValueType(Iterable<? extends Class<?>> types) {
        this.types = types;
    }

    public Class<?> mainType() {
        return (Class)Iterables.first(this.types);
    }

    @Override
    public Iterable<Class<?>> types() {
        return this.types;
    }

    public String toString() {
        String name = Iterables.toString(this.types, (Function)new Function<Class<?>, String>(){

            public String map(Class<?> item) {
                return item.getName();
            }
        }, (String)",");
        if (name.contains(",")) {
            name = "{" + name + "}";
        }
        return name;
    }
}

