/*
 * Decompiled with CFR 0.152.
 */
package org.qi4j.api.unitofwork;

import org.qi4j.api.unitofwork.UnitOfWorkException;
import org.qi4j.functional.Function;
import org.qi4j.functional.Iterables;

public class EntityTypeNotFoundException
extends UnitOfWorkException {
    private final String compositeType;

    public EntityTypeNotFoundException(String entityType, String moduleName, Iterable<String> visibility) {
        super("Could not find an EntityComposite of type " + entityType + " in module [" + moduleName + "].\n" + "\tThe following entity types are visible:\n" + EntityTypeNotFoundException.join(visibility));
        this.compositeType = entityType;
    }

    private static String join(Iterable<String> visibility) {
        return (String)Iterables.fold((Function)new Function<String, String>(){
            StringBuilder result = new StringBuilder();

            public String map(String type) {
                this.result.append(type);
                this.result.append("\n");
                return this.result.toString();
            }
        }, visibility);
    }

    public String compositeType() {
        return this.compositeType;
    }
}

