/*
 * Decompiled with CFR 0.152.
 */
package org.qi4j.api.util;

import java.lang.annotation.Annotation;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.lang.reflect.GenericArrayType;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.lang.reflect.WildcardType;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import org.qi4j.api.composite.ModelDescriptor;
import org.qi4j.functional.Function;
import org.qi4j.functional.Iterables;
import org.qi4j.functional.Specification;

public final class Classes {
    private static final Map<Type, Type> wrapperClasses = new HashMap<Type, Type>();
    private static final Map<Type, Type> primitiveClasses;
    private static final Function<Type, Type> WRAPPER_CLASS;
    private static final Function<Type, Type> PRIMITIVE_CLASS;
    public static final Function<Type, Class<?>> RAW_CLASS;
    private static final Function<AccessibleObject, Type> TYPE_OF;
    private static final Function<Type, Iterable<Class<?>>> CLASS_HIERARCHY;
    private static final Function<Type, Iterable<Type>> INTERFACES_OF;
    private static final Function<Type, Iterable<Type>> TYPES_OF;

    public static Type typeOf(AccessibleObject from) {
        return (Type)TYPE_OF.map((Object)from);
    }

    public static Iterable<Type> typesOf(Iterable<Type> types) {
        Iterable result = Iterables.empty();
        for (Type type : types) {
            result = Iterables.flatten((Iterable[])new Iterable[]{result, Classes.typesOf(type)});
        }
        return result;
    }

    public static Iterable<Type> typesOf(Type type) {
        return (Iterable)TYPES_OF.map((Object)type);
    }

    public static Iterable<? extends Type> interfacesOf(Iterable<? extends Type> types) {
        Iterable result = Iterables.empty();
        for (Type type : types) {
            result = Iterables.flatten((Iterable[])new Iterable[]{result, Classes.interfacesOf(type)});
        }
        return result;
    }

    public static Iterable<Type> interfacesOf(Type type) {
        return (Iterable)INTERFACES_OF.map((Object)type);
    }

    public static Iterable<Class<?>> classHierarchy(Class<?> type) {
        return (Iterable)CLASS_HIERARCHY.map(type);
    }

    public static Type wrapperClass(Type type) {
        return (Type)WRAPPER_CLASS.map((Object)type);
    }

    public static Specification<Class<?>> isAssignableFrom(final Class clazz) {
        return new Specification<Class<?>>(){

            public boolean satisfiedBy(Class<?> item) {
                return clazz.isAssignableFrom(item);
            }
        };
    }

    public static Specification<Object> instanceOf(final Class clazz) {
        return new Specification<Object>(){

            public boolean satisfiedBy(Object item) {
                return clazz.isInstance(item);
            }
        };
    }

    public static Specification<Class<?>> hasModifier(final int classModifier) {
        return new Specification<Class<?>>(){

            public boolean satisfiedBy(Class<?> item) {
                return (item.getModifiers() & classModifier) != 0;
            }
        };
    }

    public static <T> Function<Type, Iterable<T>> forClassHierarchy(final Function<Class<?>, Iterable<T>> function) {
        return new Function<Type, Iterable<T>>(){

            public Iterable<T> map(Type type) {
                return Iterables.flattenIterables((Iterable)Iterables.map((Function)function, (Iterable)((Iterable)CLASS_HIERARCHY.map((Object)type))));
            }
        };
    }

    public static <T> Function<Type, Iterable<T>> forTypes(final Function<Type, Iterable<T>> function) {
        return new Function<Type, Iterable<T>>(){

            public Iterable<T> map(Type type) {
                return Iterables.flattenIterables((Iterable)Iterables.map((Function)function, (Iterable)((Iterable)TYPES_OF.map((Object)type))));
            }
        };
    }

    public static Set<Class<?>> interfacesWithMethods(Set<Class<?>> interfaces) {
        LinkedHashSet newSet = new LinkedHashSet();
        for (Class<?> type : interfaces) {
            if (!type.isInterface() || type.getDeclaredMethods().length <= 0) continue;
            newSet.add(type);
        }
        return newSet;
    }

    public static String simpleGenericNameOf(Type type) {
        StringBuilder sb = new StringBuilder();
        Classes.simpleGenericNameOf(sb, type);
        return sb.toString();
    }

    private static void simpleGenericNameOf(StringBuilder sb, Type type) {
        if (type instanceof Class) {
            sb.append(((Class)type).getSimpleName());
        } else if (type instanceof ParameterizedType) {
            ParameterizedType pt = (ParameterizedType)type;
            Classes.simpleGenericNameOf(sb, pt.getRawType());
            sb.append("<");
            boolean atLeastOne = false;
            for (Type typeArgument : pt.getActualTypeArguments()) {
                if (atLeastOne) {
                    sb.append(", ");
                }
                Classes.simpleGenericNameOf(sb, typeArgument);
                atLeastOne = true;
            }
            sb.append(">");
        } else if (type instanceof GenericArrayType) {
            GenericArrayType gat = (GenericArrayType)type;
            Classes.simpleGenericNameOf(sb, gat.getGenericComponentType());
            sb.append("[]");
        } else if (type instanceof TypeVariable) {
            TypeVariable tv = (TypeVariable)type;
            sb.append(tv.getName());
        } else if (type instanceof WildcardType) {
            WildcardType wt = (WildcardType)type;
            sb.append("? extends ");
            boolean atLeastOne = false;
            for (Type typeArgument : wt.getUpperBounds()) {
                if (atLeastOne) {
                    sb.append(", ");
                }
                Classes.simpleGenericNameOf(sb, typeArgument);
                atLeastOne = true;
            }
        } else {
            throw new IllegalArgumentException("Don't know how to deal with type:" + type);
        }
    }

    public static <AnnotationType extends Annotation> AnnotationType findAnnotationOfTypeOrAnyOfSuperTypes(Class<?> type, Class<AnnotationType> annotationClass) {
        Type clazz;
        AnnotationType result = null;
        Iterator i$ = ((Iterable)TYPES_OF.map(type)).iterator();
        while (i$.hasNext() && (result = (AnnotationType)((Class)RAW_CLASS.map((Object)(clazz = (Type)i$.next()))).getAnnotation(annotationClass)) == null) {
        }
        return result;
    }

    public static Specification<Member> memberNamed(final String name) {
        return new Specification<Member>(){

            public boolean satisfiedBy(Member item) {
                return item.getName().equals(name);
            }
        };
    }

    public static Type resolveTypeVariable(TypeVariable name, Class declaringClass, Class topClass) {
        Object type = Classes.resolveTypeVariable(name, declaringClass, new HashMap<TypeVariable, Type>(), topClass);
        if (type == null) {
            type = Object.class;
        }
        return type;
    }

    private static Type resolveTypeVariable(TypeVariable name, Class declaringClass, Map<TypeVariable, Type> mappings, Class current) {
        if (current.equals(declaringClass)) {
            Type resolvedType = name;
            while (resolvedType instanceof TypeVariable) {
                resolvedType = mappings.get(resolvedType);
            }
            return resolvedType;
        }
        ArrayList<Type> types = new ArrayList<Type>();
        for (Type type : current.getGenericInterfaces()) {
            Iterable interfaces = (Iterable)INTERFACES_OF.map((Object)type);
            for (Type anInterface : interfaces) {
                if (types.contains(anInterface)) continue;
                types.add(anInterface);
            }
            types.add(type);
        }
        if (current.getGenericSuperclass() != null) {
            types.add(current.getGenericSuperclass());
        }
        for (Type type : types) {
            Type resolvedType;
            Class subClass;
            if (type instanceof ParameterizedType) {
                ParameterizedType pt = (ParameterizedType)type;
                Type[] args = pt.getActualTypeArguments();
                Class clazz = (Class)pt.getRawType();
                TypeVariable<Class<T>>[] vars = clazz.getTypeParameters();
                for (int i = 0; i < vars.length; ++i) {
                    TypeVariable var = vars[i];
                    Type mappedType = args[i];
                    mappings.put(var, mappedType);
                }
                subClass = (Class)pt.getRawType();
            } else {
                subClass = (Class)type;
            }
            if ((resolvedType = Classes.resolveTypeVariable(name, declaringClass, mappings, subClass)) == null) continue;
            return resolvedType;
        }
        return null;
    }

    public static String toURI(Class clazz) throws NullPointerException {
        return Classes.toURI(clazz.getName());
    }

    public static String toURI(String className) throws NullPointerException {
        className = Classes.normalizeClassToURI(className);
        return "urn:qi4j:type:" + className;
    }

    public static String toClassName(String uri) throws NullPointerException {
        uri = uri.substring("urn:qi4j:type:".length());
        uri = Classes.denormalizeURIToClass(uri);
        return uri;
    }

    public static String normalizeClassToURI(String className) {
        return className.replace('$', '-');
    }

    public static String denormalizeURIToClass(String uriPart) {
        return uriPart.replace('-', '$');
    }

    public static Specification<ModelDescriptor> modelTypeSpecification(final String className) {
        return new Specification<ModelDescriptor>(){

            public boolean satisfiedBy(ModelDescriptor item) {
                return Iterables.matchesAny((Specification)new Specification<String>(){

                    public boolean satisfiedBy(String item) {
                        return item.equals(className);
                    }
                }, (Iterable)Iterables.map((Function)new Function<Class<?>, String>(){

                    public String map(Class<?> item) {
                        return item.getName();
                    }
                }, item.types()));
            }
        };
    }

    public static Specification<ModelDescriptor> exactTypeSpecification(final Class type) {
        return new Specification<ModelDescriptor>(){

            public boolean satisfiedBy(ModelDescriptor item) {
                return Iterables.matchesAny((Specification)new Specification<Class<?>>(){

                    public boolean satisfiedBy(Class<?> item) {
                        return item.equals(type);
                    }
                }, item.types());
            }
        };
    }

    public static Specification<ModelDescriptor> assignableTypeSpecification(final Class type) {
        return new Specification<ModelDescriptor>(){

            public boolean satisfiedBy(ModelDescriptor item) {
                return Iterables.matchesAny((Specification)new Specification<Class<?>>(){

                    public boolean satisfiedBy(Class<?> itemType) {
                        return !type.equals(itemType) && type.isAssignableFrom(itemType);
                    }
                }, item.types());
            }
        };
    }

    public static String toString(Iterable<? extends Class> type) {
        StringBuilder builder = new StringBuilder();
        builder.append("[");
        boolean first = true;
        for (Class clazz : type) {
            if (!first) {
                builder.append(",");
            }
            first = false;
            builder.append(clazz.getSimpleName());
        }
        builder.append("]");
        return builder.toString();
    }

    public static Function<Type, String> toClassName() {
        return new Function<Type, String>(){

            public String map(Type type) {
                return ((Class)RAW_CLASS.map((Object)type)).getName();
            }
        };
    }

    private Classes() {
    }

    static {
        wrapperClasses.put(Boolean.TYPE, (Type)((Object)Boolean.class));
        wrapperClasses.put(Byte.TYPE, (Type)((Object)Byte.class));
        wrapperClasses.put(Short.TYPE, (Type)((Object)Short.class));
        wrapperClasses.put(Character.TYPE, (Type)((Object)Character.class));
        wrapperClasses.put(Integer.TYPE, (Type)((Object)Integer.class));
        wrapperClasses.put(Long.TYPE, (Type)((Object)Long.class));
        wrapperClasses.put(Float.TYPE, (Type)((Object)Float.class));
        wrapperClasses.put(Double.TYPE, (Type)((Object)Double.class));
        primitiveClasses = new HashMap<Type, Type>();
        primitiveClasses.put(Boolean.TYPE, (Type)((Object)Boolean.class));
        primitiveClasses.put(Byte.TYPE, (Type)((Object)Byte.class));
        primitiveClasses.put(Short.TYPE, (Type)((Object)Short.class));
        primitiveClasses.put(Character.TYPE, (Type)((Object)Character.class));
        primitiveClasses.put(Integer.TYPE, (Type)((Object)Integer.class));
        primitiveClasses.put(Long.TYPE, (Type)((Object)Long.class));
        primitiveClasses.put(Float.TYPE, (Type)((Object)Float.class));
        primitiveClasses.put(Double.TYPE, (Type)((Object)Double.class));
        WRAPPER_CLASS = new Function<Type, Type>(){

            public Type map(Type aClass) {
                Type wrapperClass = (Type)wrapperClasses.get(aClass);
                return wrapperClass == null ? aClass : wrapperClass;
            }
        };
        PRIMITIVE_CLASS = new Function<Type, Type>(){

            public Type map(Type aClass) {
                Type primitiveClass = (Type)primitiveClasses.get(aClass);
                return primitiveClass == null ? aClass : primitiveClass;
            }
        };
        RAW_CLASS = new Function<Type, Class<?>>(){

            public Class<?> map(Type genericType) {
                if (genericType instanceof Class) {
                    return (Class)genericType;
                }
                if (genericType instanceof ParameterizedType) {
                    return (Class)((ParameterizedType)genericType).getRawType();
                }
                if (genericType instanceof TypeVariable) {
                    return (Class)((TypeVariable)genericType).getGenericDeclaration();
                }
                if (genericType instanceof WildcardType) {
                    return (Class)((WildcardType)genericType).getUpperBounds()[0];
                }
                if (genericType instanceof GenericArrayType) {
                    Object temp = Array.newInstance((Class)((GenericArrayType)genericType).getGenericComponentType(), 0);
                    return temp.getClass();
                }
                throw new IllegalArgumentException("Could not extract the raw class of " + genericType);
            }
        };
        TYPE_OF = new Function<AccessibleObject, Type>(){

            public Type map(AccessibleObject accessor) {
                return accessor instanceof Method ? ((Method)accessor).getGenericReturnType() : ((Field)accessor).getGenericType();
            }
        };
        CLASS_HIERARCHY = new Function<Type, Iterable<Class<?>>>(){

            public Iterable<Class<?>> map(Type type) {
                if (type == null) {
                    return Iterables.empty();
                }
                if (type.equals(Object.class)) {
                    Class aClass = (Class)type;
                    return Iterables.cast((Iterable)Iterables.iterable((Object[])new Class[]{aClass}));
                }
                type = (Type)RAW_CLASS.map((Object)type);
                Class superclass = ((Class)type).getSuperclass();
                return Iterables.prepend((Object)((Class)type), this.map(superclass));
            }
        };
        INTERFACES_OF = new Function<Type, Iterable<Type>>(){

            public Iterable<Type> map(Type type) {
                Class clazz = (Class)RAW_CLASS.map((Object)type);
                if (clazz.isInterface()) {
                    Iterable genericInterfaces = Iterables.iterable((Object[])clazz.getGenericInterfaces());
                    Iterable flattenIterables = Iterables.flattenIterables((Iterable)Iterables.map((Function)INTERFACES_OF, (Iterable)genericInterfaces));
                    return Iterables.prepend((Object)type, (Iterable)flattenIterables);
                }
                if (type.equals(Object.class)) {
                    return Iterables.iterable((Object[])clazz.getGenericInterfaces());
                }
                return Iterables.flatten((Iterable[])new Iterable[]{Iterables.flattenIterables((Iterable)Iterables.map((Function)INTERFACES_OF, (Iterable)Iterables.iterable((Object[])clazz.getGenericInterfaces()))), (Iterable)INTERFACES_OF.map(((Class)RAW_CLASS.map((Object)type)).getSuperclass())});
            }
        };
        TYPES_OF = new Function<Type, Iterable<Type>>(){

            public Iterable<Type> map(Type type) {
                Class clazz = (Class)RAW_CLASS.map((Object)type);
                if (clazz.isInterface()) {
                    Iterable genericInterfaces = Iterables.iterable((Object[])clazz.getGenericInterfaces());
                    Iterable flattenIterables = Iterables.flattenIterables((Iterable)Iterables.map((Function)INTERFACES_OF, (Iterable)genericInterfaces));
                    return Iterables.prepend((Object)clazz, (Iterable)flattenIterables);
                }
                return Iterables.flatten((Iterable[])new Iterable[]{(Iterable)CLASS_HIERARCHY.map((Object)type), Iterables.flattenIterables((Iterable)Iterables.map((Function)INTERFACES_OF, (Iterable)((Iterable)CLASS_HIERARCHY.map((Object)type))))});
            }
        };
    }
}

