/*
 * Decompiled with CFR 0.152.
 */
package org.qi4j.library.rest.admin;

import java.io.IOException;
import java.io.PrintWriter;
import java.io.Writer;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.Map;
import org.openrdf.rio.RDFHandlerException;
import org.qi4j.api.association.AssociationDescriptor;
import org.qi4j.api.entity.EntityDescriptor;
import org.qi4j.api.entity.EntityReference;
import org.qi4j.api.injection.scope.Service;
import org.qi4j.api.injection.scope.Structure;
import org.qi4j.api.injection.scope.Uses;
import org.qi4j.api.property.PropertyDescriptor;
import org.qi4j.api.usecase.Usecase;
import org.qi4j.api.usecase.UsecaseBuilder;
import org.qi4j.api.value.ValueSerialization;
import org.qi4j.library.rdf.entity.EntityStateSerializer;
import org.qi4j.library.rdf.serializer.RdfXmlSerializer;
import org.qi4j.spi.entity.EntityState;
import org.qi4j.spi.entity.ManyAssociationState;
import org.qi4j.spi.entitystore.EntityNotFoundException;
import org.qi4j.spi.entitystore.EntityStore;
import org.qi4j.spi.entitystore.EntityStoreUnitOfWork;
import org.qi4j.spi.entitystore.helpers.JSONEntityState;
import org.qi4j.spi.module.ModuleSpi;
import org.restlet.data.CharacterSet;
import org.restlet.data.Language;
import org.restlet.data.MediaType;
import org.restlet.data.Method;
import org.restlet.data.Status;
import org.restlet.data.Tag;
import org.restlet.representation.EmptyRepresentation;
import org.restlet.representation.Representation;
import org.restlet.representation.StringRepresentation;
import org.restlet.representation.Variant;
import org.restlet.representation.WriterRepresentation;
import org.restlet.resource.ResourceException;
import org.restlet.resource.ServerResource;

public class EntityResource
extends ServerResource {
    @Service
    private EntityStore entityStore;
    @Service
    private ValueSerialization valueSerialization;
    @Structure
    private ModuleSpi module;
    @Uses
    private EntityStateSerializer entitySerializer;
    private String identity;

    public EntityResource() {
        this.getVariants().addAll(Arrays.asList(new Variant(MediaType.TEXT_HTML), new Variant(MediaType.APPLICATION_RDF_XML), new Variant(MediaType.APPLICATION_JSON)));
        this.setNegotiated(true);
        this.setAllowedMethods(Collections.singleton(Method.ALL));
    }

    protected void doInit() throws ResourceException {
        Map attributes = this.getRequest().getAttributes();
        this.identity = (String)attributes.get("identity");
    }

    protected Representation delete(Variant variant) throws ResourceException {
        Usecase usecase = UsecaseBuilder.newUsecase((String)"Remove entity");
        EntityStoreUnitOfWork uow = this.entityStore.newUnitOfWork(usecase, this.module, System.currentTimeMillis());
        try {
            EntityReference identityRef = EntityReference.parseEntityReference((String)this.identity);
            uow.entityStateOf(this.module, identityRef).remove();
            uow.applyChanges().commit();
            this.getResponse().setStatus(Status.SUCCESS_NO_CONTENT);
        }
        catch (EntityNotFoundException e) {
            uow.discard();
            this.getResponse().setStatus(Status.CLIENT_ERROR_NOT_FOUND);
        }
        return new EmptyRepresentation();
    }

    protected Representation get(Variant variant) throws ResourceException {
        EntityStoreUnitOfWork uow = this.entityStore.newUnitOfWork(UsecaseBuilder.newUsecase((String)"Get entity"), this.module, System.currentTimeMillis());
        try {
            EntityState entityState = this.getEntityState(uow);
            Date lastModified = this.getRequest().getConditions().getModifiedSince();
            if (lastModified != null && lastModified.getTime() / 1000L == entityState.lastModified() / 1000L) {
                throw new ResourceException(Status.REDIRECTION_NOT_MODIFIED);
            }
            if (MediaType.APPLICATION_RDF_XML.equals((Object)variant.getMediaType())) {
                return this.entityHeaders(this.representRdfXml(entityState), entityState);
            }
            if (MediaType.TEXT_HTML.equals((Object)variant.getMediaType())) {
                return this.entityHeaders(this.representHtml(entityState), entityState);
            }
            if (MediaType.APPLICATION_JSON.equals((Object)variant.getMediaType())) {
                return this.entityHeaders(this.representJson(entityState), entityState);
            }
        }
        catch (ResourceException ex) {
            uow.discard();
            throw ex;
        }
        throw new ResourceException(Status.CLIENT_ERROR_NOT_FOUND);
    }

    private EntityState getEntityState(EntityStoreUnitOfWork unitOfWork) throws ResourceException {
        EntityState entityState;
        try {
            EntityReference entityReference = EntityReference.parseEntityReference((String)this.identity);
            entityState = unitOfWork.entityStateOf(this.module, entityReference);
        }
        catch (EntityNotFoundException e) {
            throw new ResourceException(Status.CLIENT_ERROR_NOT_FOUND);
        }
        return entityState;
    }

    private Representation entityHeaders(Representation representation, EntityState entityState) {
        representation.setModificationDate(new Date(entityState.lastModified()));
        representation.setTag(new Tag("" + entityState.version()));
        representation.setCharacterSet(CharacterSet.UTF_8);
        representation.setLanguages(Collections.singletonList(Language.ENGLISH));
        return representation;
    }

    private Representation representHtml(final EntityState entity) {
        return new WriterRepresentation(MediaType.TEXT_HTML){

            public void write(Writer writer) throws IOException {
                String value;
                ManyAssociationState identities;
                Object value2;
                PrintWriter out = new PrintWriter(writer);
                out.println("<html><head><title>" + entity.identity() + "</title>" + "<link rel=\"alternate\" type=\"application/rdf+xml\" " + "href=\"" + entity.identity() + ".rdf\"/></head><body>");
                out.println("<h1>" + entity.identity() + "</h1>");
                out.println("<form method=\"post\" action=\"" + EntityResource.this.getRequest().getResourceRef().getPath() + "\">\n");
                out.println("<fieldset><legend>Properties</legend>\n<table>");
                EntityDescriptor descriptor = entity.entityDescriptor();
                for (PropertyDescriptor persistentProperty : descriptor.state().properties()) {
                    value2 = entity.propertyValueOf(persistentProperty.qualifiedName());
                    out.println("<tr><td><label for=\"" + persistentProperty.qualifiedName() + "\" >" + persistentProperty.qualifiedName().name() + "</label></td>\n" + "<td><input " + "size=\"80\" " + "type=\"text\" " + (persistentProperty.isImmutable() ? "readonly=\"true\" " : "") + "name=\"" + persistentProperty.qualifiedName() + "\" " + "value=\"" + (value2 == null ? "" : EntityResource.this.valueSerialization.serialize(value2)) + "\"/></td></tr>");
                }
                out.println("</table></fieldset>\n");
                out.println("<fieldset><legend>Associations</legend>\n<table>");
                for (AssociationDescriptor associationType : descriptor.state().associations()) {
                    value2 = entity.associationValueOf(associationType.qualifiedName());
                    if (value2 == null) {
                        value2 = "";
                    }
                    out.println("<tr><td><label for=\"" + associationType.qualifiedName() + "\" >" + associationType.qualifiedName().name() + "</label></td>\n" + "<td><input " + "type=\"text\" " + "size=\"80\" " + "name=\"" + associationType.qualifiedName() + "\" " + "value=\"" + value2 + "\"/></td></tr>");
                }
                out.println("</table></fieldset>\n");
                out.println("<fieldset><legend>ManyAssociations</legend>\n<table>");
                for (AssociationDescriptor associationType : descriptor.state().manyAssociations()) {
                    identities = entity.manyAssociationValueOf(associationType.qualifiedName());
                    value = "";
                    for (EntityReference identity : identities) {
                        value = value + identity.identity() + "\n";
                    }
                    out.println("<tr><td><label for=\"" + associationType.qualifiedName() + "\" >" + associationType.qualifiedName().name() + "</label></td>\n" + "<td><textarea " + "rows=\"10\" " + "cols=\"80\" " + "name=\"" + associationType.qualifiedName() + "\" >" + value + "</textarea></td></tr>");
                }
                out.println("</table></fieldset>\n");
                out.println("<fieldset><legend>NamedAssociations</legend>\n<table>");
                for (AssociationDescriptor associationType : descriptor.state().namedAssociations()) {
                    identities = entity.namedAssociationValueOf(associationType.qualifiedName());
                    value = "";
                    for (String name : identities) {
                        value = value + name + "\n" + identities.get(name).identity() + "\n";
                    }
                    out.println("<tr><td><label for=\"" + associationType.qualifiedName() + "\" >" + associationType.qualifiedName().name() + "</label></td>\n" + "<td><textarea " + "rows=\"10\" " + "cols=\"80\" " + "name=\"" + associationType.qualifiedName() + "\" >" + value + "</textarea></td></tr>");
                }
                out.println("</table></fieldset>\n");
                out.println("<input type=\"submit\" value=\"Update\"/></form>\n");
                out.println("</body></html>\n");
            }
        };
    }

    private Representation representJson(EntityState entityState) {
        if (entityState instanceof JSONEntityState) {
            JSONEntityState jsonState = (JSONEntityState)entityState;
            return new StringRepresentation((CharSequence)jsonState.state().toString(), MediaType.APPLICATION_JSON);
        }
        throw new ResourceException(Status.CLIENT_ERROR_NOT_ACCEPTABLE);
    }

    private Representation representRdfXml(final EntityState entity) throws ResourceException {
        WriterRepresentation representation = new WriterRepresentation(MediaType.APPLICATION_RDF_XML){

            public void write(Writer writer) throws IOException {
                try {
                    Iterable statements = EntityResource.this.entitySerializer.serialize(entity);
                    new RdfXmlSerializer().serialize(statements, writer);
                }
                catch (RDFHandlerException e) {
                    throw new IOException(e);
                }
            }
        };
        representation.setCharacterSet(CharacterSet.UTF_8);
        return representation;
    }

    protected Representation put(Representation representation, Variant variant) throws ResourceException {
        return this.post(representation, variant);
    }

    /*
     * Exception decompiling
     */
    public Representation post(Representation entityRepresentation, Variant variant) throws ResourceException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [21[UNCONDITIONALDOLOOP]], but top level block is 3[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }
}

