/*
 * Decompiled with CFR 0.152.
 */
package org.qi4j.library.rest.admin;

import org.qi4j.api.injection.scope.Structure;
import org.qi4j.api.injection.scope.Uses;
import org.qi4j.api.structure.Module;
import org.qi4j.api.unitofwork.ConcurrentEntityModificationException;
import org.qi4j.api.unitofwork.UnitOfWork;
import org.qi4j.api.unitofwork.UnitOfWorkCompletionException;
import org.qi4j.api.unitofwork.UnitOfWorkException;
import org.qi4j.library.rest.admin.EntitiesResource;
import org.qi4j.library.rest.admin.EntityResource;
import org.qi4j.library.rest.admin.ExceptionRepresentation;
import org.qi4j.library.rest.admin.IndexResource;
import org.qi4j.library.rest.admin.SPARQLResource;
import org.restlet.Application;
import org.restlet.Context;
import org.restlet.Request;
import org.restlet.Response;
import org.restlet.Restlet;
import org.restlet.data.MediaType;
import org.restlet.data.Metadata;
import org.restlet.data.Status;
import org.restlet.representation.Representation;
import org.restlet.resource.Finder;
import org.restlet.resource.ServerResource;
import org.restlet.routing.Router;

public class RestApplication
extends Application {
    public static final MediaType APPLICATION_SPARQL_JSON = new MediaType("application/sparql-results+json", "SPARQL JSON");
    @Structure
    private Module module;

    public RestApplication(@Uses Context parentContext) {
        super(parentContext);
        this.getMetadataService().addExtension("srj", (Metadata)APPLICATION_SPARQL_JSON);
        this.getTunnelService().setExtensionsTunnel(true);
    }

    public void handle(Request request, Response response) {
        UnitOfWork uow = this.module.newUnitOfWork();
        try {
            super.handle(request, response);
            uow.complete();
        }
        catch (UnitOfWorkException e) {
            uow.discard();
            response.setStatus(Status.CLIENT_ERROR_NOT_ACCEPTABLE);
            response.setEntity((Representation)new ExceptionRepresentation(e));
        }
        catch (ConcurrentEntityModificationException e) {
            uow.discard();
            response.setStatus(Status.CLIENT_ERROR_LOCKED);
            response.setEntity((Representation)new ExceptionRepresentation(e));
        }
        catch (UnitOfWorkCompletionException e) {
            uow.discard();
            response.setStatus(Status.CLIENT_ERROR_NOT_ACCEPTABLE);
            response.setEntity((Representation)new ExceptionRepresentation(e));
        }
    }

    public synchronized Restlet createInboundRoot() {
        Router router = new Router(this.getContext());
        router.attach("/entity", (Restlet)this.createFinder(EntitiesResource.class));
        router.attach("/entity/{identity}", (Restlet)this.createFinder(EntityResource.class));
        router.attach("/query", (Restlet)this.createFinder(SPARQLResource.class));
        router.attach("/query/sparqlhtml", (Restlet)this.createFinder(SPARQLResource.class));
        router.attach("/query/index", (Restlet)this.createFinder(IndexResource.class));
        return router;
    }

    private Finder createFinder(Class<? extends ServerResource> resource) {
        Finder finder = (Finder)this.module.newObject(Finder.class, new Object[0]);
        finder.setTargetClass(resource);
        return finder;
    }
}

