/*
 * Decompiled with CFR 0.152.
 */
package org.qi4j.library.rest.admin;

import info.aduna.xml.XMLWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.util.Arrays;
import java.util.Collections;
import java.util.Enumeration;
import org.openrdf.http.protocol.Protocol;
import org.openrdf.model.URI;
import org.openrdf.model.Value;
import org.openrdf.model.ValueFactory;
import org.openrdf.query.BooleanQuery;
import org.openrdf.query.Dataset;
import org.openrdf.query.GraphQuery;
import org.openrdf.query.MalformedQueryException;
import org.openrdf.query.Query;
import org.openrdf.query.QueryEvaluationException;
import org.openrdf.query.QueryLanguage;
import org.openrdf.query.QueryResultHandler;
import org.openrdf.query.QueryResultUtil;
import org.openrdf.query.TupleQuery;
import org.openrdf.query.TupleQueryResult;
import org.openrdf.query.UnsupportedQueryLanguageException;
import org.openrdf.query.impl.DatasetImpl;
import org.openrdf.query.resultio.TupleQueryResultWriter;
import org.openrdf.query.resultio.sparqljson.SPARQLResultsJSONWriterFactory;
import org.openrdf.query.resultio.sparqlxml.SPARQLResultsXMLWriter;
import org.openrdf.repository.Repository;
import org.openrdf.repository.RepositoryConnection;
import org.openrdf.repository.RepositoryException;
import org.qi4j.api.injection.scope.Service;
import org.qi4j.library.rest.admin.RestApplication;
import org.restlet.data.Form;
import org.restlet.data.MediaType;
import org.restlet.data.Method;
import org.restlet.data.Status;
import org.restlet.representation.InputRepresentation;
import org.restlet.representation.OutputRepresentation;
import org.restlet.representation.Representation;
import org.restlet.representation.Variant;
import org.restlet.resource.ResourceException;
import org.restlet.resource.ServerResource;

public class SPARQLResource
extends ServerResource {
    @Service
    Repository repository;

    public SPARQLResource() {
        this.getVariants().addAll(Arrays.asList(new Variant(MediaType.TEXT_HTML), new Variant(MediaType.APPLICATION_RDF_XML), new Variant(RestApplication.APPLICATION_SPARQL_JSON)));
        this.setNegotiated(true);
    }

    protected void doInit() throws ResourceException {
        super.doInit();
    }

    public Representation get(Variant variant) throws ResourceException {
        block11: {
            try {
                if (this.getRequest().getOriginalRef().getLastSegment().equals("sparqlhtml.xsl")) {
                    InputStream resourceAsStream = ((Object)((Object)this)).getClass().getResourceAsStream("sparqlhtml.xsl");
                    return new InputRepresentation(resourceAsStream, MediaType.TEXT_XML);
                }
                Form form = this.getRequest().getMethod().equals((Object)Method.POST) ? new Form(this.getRequest().getEntity()) : this.getRequest().getResourceRef().getQueryAsForm();
                final RepositoryConnection conn = this.repository.getConnection();
                String queryStr = form.getFirstValue("query");
                if (queryStr == null) {
                    InputStream resourceAsStream = ((Object)((Object)this)).getClass().getResourceAsStream("sparqlform.html");
                    return new InputRepresentation(resourceAsStream, MediaType.TEXT_HTML);
                }
                Query query = this.getQuery(this.repository, conn, queryStr);
                if (query instanceof TupleQuery) {
                    TupleQuery tQuery = (TupleQuery)query;
                    final TupleQueryResult queryResult = tQuery.evaluate();
                    if (variant.getMediaType().equals((Object)MediaType.TEXT_HTML)) {
                        return new OutputRepresentation(MediaType.TEXT_XML){

                            public void write(OutputStream outputStream) throws IOException {
                                try {
                                    PrintWriter out = new PrintWriter(outputStream);
                                    out.println("<?xml version='1.0' encoding='UTF-8'?>");
                                    out.println("<?xml-stylesheet type=\"text/xsl\" href=\"query/sparqlhtml.xsl\"?>");
                                    out.flush();
                                    SPARQLResultsXMLWriter qrWriter = new SPARQLResultsXMLWriter(new XMLWriter(outputStream){

                                        public void startDocument() throws IOException {
                                        }
                                    });
                                    QueryResultUtil.report((TupleQueryResult)queryResult, (QueryResultHandler)qrWriter);
                                }
                                catch (Exception e) {
                                    throw new IOException(e);
                                }
                                finally {
                                    try {
                                        conn.close();
                                    }
                                    catch (RepositoryException e) {}
                                }
                            }
                        };
                    }
                    if (variant.getMediaType().equals((Object)MediaType.APPLICATION_RDF_XML)) {
                        return new OutputRepresentation(MediaType.APPLICATION_XML){

                            public void write(OutputStream outputStream) throws IOException {
                                try {
                                    SPARQLResultsXMLWriter qrWriter = new SPARQLResultsXMLWriter(new XMLWriter(outputStream));
                                    QueryResultUtil.report((TupleQueryResult)queryResult, (QueryResultHandler)qrWriter);
                                }
                                catch (Exception e) {
                                    throw new IOException(e);
                                }
                                finally {
                                    try {
                                        conn.close();
                                    }
                                    catch (RepositoryException e) {}
                                }
                            }
                        };
                    }
                    if (variant.getMediaType().equals((Object)RestApplication.APPLICATION_SPARQL_JSON)) {
                        return new OutputRepresentation(RestApplication.APPLICATION_SPARQL_JSON){

                            public void write(OutputStream outputStream) throws IOException {
                                try {
                                    TupleQueryResultWriter qrWriter = new SPARQLResultsJSONWriterFactory().getWriter(outputStream);
                                    QueryResultUtil.report((TupleQueryResult)queryResult, (QueryResultHandler)qrWriter);
                                }
                                catch (Exception e) {
                                    throw new IOException(e);
                                }
                                finally {
                                    try {
                                        conn.close();
                                    }
                                    catch (RepositoryException e) {}
                                }
                            }
                        };
                    }
                    break block11;
                }
                if (query instanceof GraphQuery) {
                    GraphQuery gQuery = (GraphQuery)query;
                    conn.close();
                    break block11;
                }
                if (query instanceof BooleanQuery) {
                    BooleanQuery bQuery = (BooleanQuery)query;
                    conn.close();
                    break block11;
                }
                conn.close();
                throw new ResourceException(Status.CLIENT_ERROR_BAD_REQUEST, "Unsupported query type: " + query.getClass().getName());
            }
            catch (RepositoryException e) {
                throw new ResourceException(Status.SERVER_ERROR_INTERNAL, (Throwable)e);
            }
            catch (QueryEvaluationException e) {
                throw new ResourceException(Status.SERVER_ERROR_INTERNAL, (Throwable)e);
            }
        }
        return null;
    }

    private Query getQuery(Repository repository, RepositoryConnection repositoryCon, String queryStr) throws ResourceException {
        Query result;
        Form form = this.getRequest().getResourceRef().getQueryAsForm();
        QueryLanguage queryLn = QueryLanguage.SPARQL;
        boolean includeInferred = true;
        String[] defaultGraphURIs = form.getValuesArray("default-graph-uri");
        String[] namedGraphURIs = form.getValuesArray("named-graph-uri");
        DatasetImpl dataset = null;
        if (defaultGraphURIs.length > 0 || namedGraphURIs.length > 0) {
            URI uri;
            dataset = new DatasetImpl();
            if (defaultGraphURIs.length > 0) {
                for (String defaultGraphURI : defaultGraphURIs) {
                    try {
                        uri = repository.getValueFactory().createURI(defaultGraphURI);
                        dataset.addDefaultGraph(uri);
                    }
                    catch (IllegalArgumentException e) {
                        throw new ResourceException(Status.CLIENT_ERROR_BAD_REQUEST, "Illegal URI for default graph: " + defaultGraphURI);
                    }
                }
            }
            if (namedGraphURIs.length > 0) {
                for (String namedGraphURI : namedGraphURIs) {
                    try {
                        uri = repository.getValueFactory().createURI(namedGraphURI);
                        dataset.addNamedGraph(uri);
                    }
                    catch (IllegalArgumentException e) {
                        throw new ResourceException(Status.CLIENT_ERROR_BAD_REQUEST, "Illegal URI for named graph: " + namedGraphURI);
                    }
                }
            }
        }
        try {
            result = repositoryCon.prepareQuery(queryLn, queryStr);
            result.setIncludeInferred(includeInferred);
            if (dataset != null) {
                result.setDataset((Dataset)dataset);
            }
            Enumeration parameterNames = Collections.enumeration(form.getValuesMap().keySet());
            while (parameterNames.hasMoreElements()) {
                String parameterName = (String)parameterNames.nextElement();
                if (!parameterName.startsWith("$") || parameterName.length() <= "$".length()) continue;
                String bindingName = parameterName.substring("$".length());
                Value bindingValue = this.parseValueParam(repository, form, parameterName);
                result.setBinding(bindingName, bindingValue);
            }
        }
        catch (UnsupportedQueryLanguageException e) {
            throw new ResourceException(Status.CLIENT_ERROR_BAD_REQUEST, e.getMessage());
        }
        catch (MalformedQueryException e) {
            throw new ResourceException(Status.CLIENT_ERROR_BAD_REQUEST, e.getMessage());
        }
        catch (RepositoryException e) {
            throw new ResourceException(Status.SERVER_ERROR_INTERNAL, e.getMessage());
        }
        return result;
    }

    private Value parseValueParam(Repository repository, Form form, String parameterName) throws ResourceException {
        String paramValue = form.getFirstValue(parameterName);
        try {
            return Protocol.decodeValue((String)paramValue, (ValueFactory)repository.getValueFactory());
        }
        catch (IllegalArgumentException e) {
            throw new ResourceException(Status.CLIENT_ERROR_BAD_REQUEST, "Invalid value for parameter '" + parameterName + "': " + paramValue);
        }
    }
}

