/*
 * Decompiled with CFR 0.152.
 */
package org.qi4j.entitystore.leveldb;

import java.io.File;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.nio.charset.Charset;
import org.iq80.leveldb.CompressionType;
import org.iq80.leveldb.DB;
import org.iq80.leveldb.DBFactory;
import org.iq80.leveldb.DBIterator;
import org.iq80.leveldb.Options;
import org.iq80.leveldb.WriteBatch;
import org.qi4j.api.configuration.Configuration;
import org.qi4j.api.entity.EntityDescriptor;
import org.qi4j.api.entity.EntityReference;
import org.qi4j.api.injection.scope.Service;
import org.qi4j.api.injection.scope.This;
import org.qi4j.api.injection.scope.Uses;
import org.qi4j.api.service.ServiceActivation;
import org.qi4j.api.service.ServiceDescriptor;
import org.qi4j.entitystore.leveldb.LevelDBEntityStoreConfiguration;
import org.qi4j.io.Input;
import org.qi4j.io.Output;
import org.qi4j.io.Receiver;
import org.qi4j.io.Sender;
import org.qi4j.library.fileconfig.FileConfiguration;
import org.qi4j.spi.entitystore.EntityNotFoundException;
import org.qi4j.spi.entitystore.EntityStoreException;
import org.qi4j.spi.entitystore.helpers.MapEntityStore;

public class LevelDBEntityStoreMixin
implements ServiceActivation,
MapEntityStore {
    @Service
    private FileConfiguration fileConfig;
    @This
    private Configuration<LevelDBEntityStoreConfiguration> configuration;
    @Uses
    private ServiceDescriptor descriptor;
    private Charset charset;
    private DB db;

    public void activateService() throws Exception {
        this.charset = Charset.forName("UTF-8");
        this.configuration.refresh();
        LevelDBEntityStoreConfiguration config = (LevelDBEntityStoreConfiguration)this.configuration.get();
        String flavour = (String)config.flavour().get();
        DBFactory factory = "jni".equalsIgnoreCase(flavour) ? this.newJniDBFactory() : ("java".equalsIgnoreCase(flavour) ? this.newJavaDBFactory() : this.newDBFactory());
        Options options = new Options();
        options.createIfMissing(true);
        if (config.blockRestartInterval().get() != null) {
            options.blockRestartInterval(((Integer)config.blockRestartInterval().get()).intValue());
        }
        if (config.blockSize().get() != null) {
            options.blockSize(((Integer)config.blockSize().get()).intValue());
        }
        if (config.cacheSize().get() != null) {
            options.cacheSize(((Long)config.cacheSize().get()).longValue());
        }
        if (config.compression().get() != null) {
            options.compressionType((Boolean)config.compression().get() != false ? CompressionType.SNAPPY : CompressionType.NONE);
        }
        if (config.maxOpenFiles().get() != null) {
            options.maxOpenFiles(((Integer)config.maxOpenFiles().get()).intValue());
        }
        if (config.paranoidChecks().get() != null) {
            options.paranoidChecks(((Boolean)config.paranoidChecks().get()).booleanValue());
        }
        if (config.verifyChecksums().get() != null) {
            options.verifyChecksums(((Boolean)config.verifyChecksums().get()).booleanValue());
        }
        if (config.writeBufferSize().get() != null) {
            options.writeBufferSize(((Integer)config.writeBufferSize().get()).intValue());
        }
        File dbFile = new File(this.fileConfig.dataDirectory(), this.descriptor.identity());
        this.db = factory.open(dbFile, options);
    }

    private DBFactory newDBFactory() {
        try {
            return this.newJniDBFactory();
        }
        catch (Exception ex) {
            try {
                return this.newJavaDBFactory();
            }
            catch (Exception ex2) {
                throw new RuntimeException("Unable to create a LevelDB DBFactory instance. Tried JNI and pure Java. The stacktrace is the pure Java attempt.", ex2);
            }
        }
    }

    private DBFactory newJniDBFactory() throws Exception {
        return (DBFactory)Class.forName("org.fusesource.leveldbjni.JniDBFactory").newInstance();
    }

    private DBFactory newJavaDBFactory() throws Exception {
        return (DBFactory)Class.forName("org.iq80.leveldb.impl.Iq80DBFactory").newInstance();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void passivateService() throws Exception {
        try {
            this.db.close();
        }
        finally {
            this.db = null;
            this.charset = null;
        }
    }

    public Reader get(EntityReference entityReference) throws EntityStoreException {
        byte[] state = this.db.get(entityReference.identity().getBytes(this.charset));
        if (state == null) {
            throw new EntityNotFoundException(entityReference);
        }
        String jsonState = new String(state, this.charset);
        return new StringReader(jsonState);
    }

    public Input<Reader, IOException> entityStates() {
        return new Input<Reader, IOException>(){

            public <ReceiverThrowableType extends Throwable> void transferTo(Output<? super Reader, ReceiverThrowableType> output) throws IOException, ReceiverThrowableType {
                output.receiveFrom((Sender)new Sender<Reader, IOException>(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    public <ReceiverThrowableType extends Throwable> void sendTo(Receiver<? super Reader, ReceiverThrowableType> receiver) throws ReceiverThrowableType, IOException {
                        try (DBIterator iterator = LevelDBEntityStoreMixin.this.db.iterator();){
                            iterator.seekToFirst();
                            while (iterator.hasNext()) {
                                byte[] state = (byte[])iterator.peekNext().getValue();
                                String jsonState = new String(state, LevelDBEntityStoreMixin.this.charset);
                                receiver.receive((Object)new StringReader(jsonState));
                                iterator.next();
                            }
                        }
                    }
                });
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void applyChanges(MapEntityStore.MapChanges changes) throws IOException {
        try (final WriteBatch writeBatch = this.db.createWriteBatch();){
            changes.visitMap(new MapEntityStore.MapChanger(){

                public Writer newEntity(final EntityReference ref, EntityDescriptor entityDescriptor) throws IOException {
                    return new StringWriter(1000){

                        @Override
                        public void close() throws IOException {
                            super.close();
                            String jsonState = this.toString();
                            writeBatch.put(ref.identity().getBytes(LevelDBEntityStoreMixin.this.charset), jsonState.getBytes(LevelDBEntityStoreMixin.this.charset));
                        }
                    };
                }

                public Writer updateEntity(final EntityReference ref, EntityDescriptor entityDescriptor) throws IOException {
                    return new StringWriter(1000){

                        @Override
                        public void close() throws IOException {
                            super.close();
                            String jsonState = this.toString();
                            writeBatch.put(ref.identity().getBytes(LevelDBEntityStoreMixin.this.charset), jsonState.getBytes(LevelDBEntityStoreMixin.this.charset));
                        }
                    };
                }

                public void removeEntity(EntityReference ref, EntityDescriptor entityDescriptor) throws EntityNotFoundException {
                    writeBatch.delete(ref.identity().getBytes(LevelDBEntityStoreMixin.this.charset));
                }
            });
            this.db.write(writeBatch);
        }
    }
}

