/*
 * Decompiled with CFR 0.152.
 */
package org.qi4j.library.sql.assembly;

import javax.sql.DataSource;
import org.qi4j.api.service.importer.ServiceInstanceImporter;
import org.qi4j.api.util.NullArgumentException;
import org.qi4j.bootstrap.Assemblers;
import org.qi4j.bootstrap.AssemblyException;
import org.qi4j.bootstrap.ModuleAssembly;
import org.qi4j.library.circuitbreaker.CircuitBreaker;
import org.qi4j.library.sql.assembly.AbstractPooledDataSourceServiceAssembler;
import org.qi4j.library.sql.datasource.DataSources;

public class DataSourceAssembler
extends Assemblers.VisibilityIdentity<DataSourceAssembler> {
    public static String DEFAULT_DATASOURCE_IDENTITY = "datasource";
    private String dataSourceServiceId = AbstractPooledDataSourceServiceAssembler.DEFAULT_DATASOURCE_SERVICE_IDENTITY;
    private CircuitBreaker circuitBreaker;

    public DataSourceAssembler() {
        this.identifiedBy(DEFAULT_DATASOURCE_IDENTITY);
    }

    public DataSourceAssembler withDataSourceServiceIdentity(String dataSourceServiceId) {
        NullArgumentException.validateNotNull((String)"DataSourceService identity", (Object)dataSourceServiceId);
        this.dataSourceServiceId = dataSourceServiceId;
        return this;
    }

    public DataSourceAssembler withCircuitBreaker() {
        this.circuitBreaker = DataSources.newDataSourceCircuitBreaker();
        return this;
    }

    public DataSourceAssembler withCircuitBreaker(CircuitBreaker circuitBreaker) {
        NullArgumentException.validateNotNull((String)"CircuitBreaker", (Object)circuitBreaker);
        this.circuitBreaker = circuitBreaker;
        return this;
    }

    public void assemble(ModuleAssembly module) throws AssemblyException {
        module.importedServices(new Class[]{DataSource.class}).importedBy(ServiceInstanceImporter.class).setMetaInfo((Object)this.dataSourceServiceId).identifiedBy(this.identity()).visibleIn(this.visibility());
        if (this.circuitBreaker != null) {
            module.importedServices(new Class[]{DataSource.class}).identifiedBy(this.identity()).setMetaInfo((Object)this.circuitBreaker);
        }
    }
}

