/*
 * Decompiled with CFR 0.152.
 */
package org.qi4j.tools.model.descriptor;

import java.lang.reflect.Method;
import java.util.LinkedList;
import java.util.List;
import org.qi4j.api.composite.CompositeDescriptor;
import org.qi4j.api.composite.MethodDescriptor;
import org.qi4j.api.util.NullArgumentException;
import org.qi4j.tools.model.descriptor.CompositeMethodDetailDescriptor;
import org.qi4j.tools.model.descriptor.MixinDetailDescriptor;
import org.qi4j.tools.model.descriptor.ModuleDetailDescriptor;

public abstract class CompositeDetailDescriptor<T extends CompositeDescriptor> {
    protected final T descriptor;
    protected ModuleDetailDescriptor module;
    protected final List<CompositeMethodDetailDescriptor> methods;
    protected final List<MixinDetailDescriptor> mixins;

    CompositeDetailDescriptor(T aDescriptor) {
        NullArgumentException.validateNotNull((String)"aDescriptor", aDescriptor);
        this.descriptor = aDescriptor;
        this.methods = new LinkedList<CompositeMethodDetailDescriptor>();
        this.mixins = new LinkedList<MixinDetailDescriptor>();
    }

    public final T descriptor() {
        return this.descriptor;
    }

    public final Iterable<CompositeMethodDetailDescriptor> methods() {
        return this.methods;
    }

    public final Iterable<MixinDetailDescriptor> mixins() {
        return this.mixins;
    }

    public final CompositeMethodDetailDescriptor getMethodDescriptor(Method aMethod) {
        for (CompositeMethodDetailDescriptor descriptor : this.methods) {
            MethodDescriptor methodDescriptor = descriptor.descriptor();
            Method method = methodDescriptor.method();
            if (!method.equals(aMethod)) continue;
            return descriptor;
        }
        return null;
    }

    public final ModuleDetailDescriptor module() {
        return this.module;
    }

    final void setModule(ModuleDetailDescriptor aDescriptor) throws IllegalArgumentException {
        NullArgumentException.validateNotNull((String)"aDescriptor", (Object)aDescriptor);
        this.module = aDescriptor;
    }

    final void addMethod(CompositeMethodDetailDescriptor aDescriptor) throws IllegalArgumentException {
        NullArgumentException.validateNotNull((String)"aDescriptor", (Object)aDescriptor);
        aDescriptor.setComposite(this);
        this.methods.add(aDescriptor);
    }

    final void addMixin(MixinDetailDescriptor aDescriptor) throws IllegalArgumentException {
        NullArgumentException.validateNotNull((String)"aDescriptor", (Object)aDescriptor);
        aDescriptor.setComposite(this);
        this.mixins.add(aDescriptor);
    }

    public String toString() {
        return this.descriptor.toString();
    }
}

