/*
 * Decompiled with CFR 0.152.
 */
package org.qi4j.tools.model.descriptor;

import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.qi4j.api.structure.LayerDescriptor;
import org.qi4j.api.util.NullArgumentException;
import org.qi4j.functional.HierarchicalVisitor;
import org.qi4j.functional.VisitableHierarchy;
import org.qi4j.tools.model.descriptor.ActivateeDetailDescriptor;
import org.qi4j.tools.model.descriptor.ActivatorDetailDescriptor;
import org.qi4j.tools.model.descriptor.ApplicationDetailDescriptor;
import org.qi4j.tools.model.descriptor.ModuleDetailDescriptor;

public final class LayerDetailDescriptor
implements ActivateeDetailDescriptor,
VisitableHierarchy<Object, Object> {
    private final LayerDescriptor descriptor;
    private ApplicationDetailDescriptor application;
    private final List<LayerDetailDescriptor> usedLayers = new LinkedList<LayerDetailDescriptor>();
    private final List<ActivatorDetailDescriptor> activators = new LinkedList<ActivatorDetailDescriptor>();
    private final List<ModuleDetailDescriptor> modules = new LinkedList<ModuleDetailDescriptor>();

    LayerDetailDescriptor(LayerDescriptor descriptor) throws IllegalArgumentException {
        NullArgumentException.validateNotNull((String)"LayerDescriptor", (Object)descriptor);
        this.descriptor = descriptor;
    }

    public final LayerDescriptor descriptor() {
        return this.descriptor;
    }

    public final Iterable<LayerDetailDescriptor> usedLayers() {
        return this.usedLayers;
    }

    public final List<LayerDetailDescriptor> usedBy() {
        LinkedList<LayerDetailDescriptor> usedBy = new LinkedList<LayerDetailDescriptor>();
        for (LayerDetailDescriptor layer : this.application.layers()) {
            if (!layer.usedLayers.contains(this)) continue;
            usedBy.add(layer);
        }
        return usedBy;
    }

    @Override
    public Iterable<ActivatorDetailDescriptor> activators() {
        return this.activators;
    }

    public final Iterable<ModuleDetailDescriptor> modules() {
        return this.modules;
    }

    public final ApplicationDetailDescriptor application() {
        return this.application;
    }

    final void setApplication(ApplicationDetailDescriptor descriptor) {
        NullArgumentException.validateNotNull((String)"ApplicationDetailDescriptor", (Object)descriptor);
        this.application = descriptor;
    }

    final void addActivator(ActivatorDetailDescriptor descriptor) {
        NullArgumentException.validateNotNull((String)"ActivatorDetailDescriptor", (Object)descriptor);
        descriptor.setLayer(this);
        this.activators.add(descriptor);
    }

    final void addUsedLayer(LayerDetailDescriptor descriptor) {
        NullArgumentException.validateNotNull((String)"LayerDetailDescriptor", (Object)descriptor);
        this.usedLayers.add(descriptor);
    }

    final void addModule(ModuleDetailDescriptor descriptor) {
        NullArgumentException.validateNotNull((String)"ModuleDetailDescriptor", (Object)descriptor);
        descriptor.setLayer(this);
        this.modules.add(descriptor);
    }

    public <ThrowableType extends Throwable> boolean accept(HierarchicalVisitor<? super Object, ? super Object, ThrowableType> visitor) throws ThrowableType {
        block2: {
            ModuleDetailDescriptor module;
            if (!visitor.visitEnter((Object)this)) break block2;
            for (ActivatorDetailDescriptor activator : this.activators) {
                if (!activator.accept(visitor)) break;
            }
            Iterator<Object> i$ = this.modules.iterator();
            while (i$.hasNext() && (module = (ModuleDetailDescriptor)i$.next()).accept(visitor)) {
            }
        }
        return visitor.visitLeave((Object)this);
    }

    public final String toString() {
        return this.descriptor.name();
    }
}

