/*
 * Decompiled with CFR 0.152.
 */
package org.qi4j.tools.model.util;

import java.util.List;
import org.qi4j.tools.model.descriptor.CompositeDetailDescriptor;
import org.qi4j.tools.model.descriptor.CompositeMethodDetailDescriptor;
import org.qi4j.tools.model.descriptor.LayerDetailDescriptor;
import org.qi4j.tools.model.descriptor.ModuleDetailDescriptor;
import org.qi4j.tools.model.descriptor.ServiceDetailDescriptor;
import org.qi4j.tools.model.descriptor.ServiceUsage;
import org.qi4j.tools.model.util.APIFinder;
import org.qi4j.tools.model.util.MethodFinder;
import org.qi4j.tools.model.util.SPIFinder;
import org.qi4j.tools.model.util.ServiceConfigurationFinder;
import org.qi4j.tools.model.util.ServiceUsageFinder;
import org.qi4j.tools.model.util.StateFinder;

public class DescriptorUtilities {
    private DescriptorUtilities() {
        throw new Error("This is a utility class for static methods");
    }

    public static List<CompositeMethodDetailDescriptor> findMethod(CompositeDetailDescriptor descriptor) {
        return new MethodFinder().findMethod(descriptor);
    }

    public static List<CompositeMethodDetailDescriptor> findState(CompositeDetailDescriptor descriptor) {
        return new StateFinder().findState(descriptor);
    }

    public static Object findServiceConfiguration(ServiceDetailDescriptor descriptor) {
        return new ServiceConfigurationFinder().findConfigurationDescriptor(descriptor);
    }

    public static List<ServiceUsage> findServiceUsage(ServiceDetailDescriptor descriptor) {
        return new ServiceUsageFinder().findServiceUsage(descriptor);
    }

    public static List<ServiceDetailDescriptor> findModuleAPI(ModuleDetailDescriptor descriptor) {
        return new APIFinder().findModuleAPI(descriptor);
    }

    public static List<ServiceDetailDescriptor> findLayerAPI(LayerDetailDescriptor descriptor) {
        return new APIFinder().findLayerAPI(descriptor);
    }

    public static List<ServiceDetailDescriptor> findModule(ModuleDetailDescriptor descriptor) {
        return new SPIFinder().findModule(descriptor);
    }

    public static List<ServiceDetailDescriptor> findLayerSPI(LayerDetailDescriptor descriptor) {
        return new SPIFinder().findLayerSPI(descriptor);
    }
}

