/*
 * Decompiled with CFR 0.152.
 */
package org.qi4j.tools.model.util;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.qi4j.api.association.Association;
import org.qi4j.api.association.ManyAssociation;
import org.qi4j.api.association.NamedAssociation;
import org.qi4j.api.property.Property;
import org.qi4j.tools.model.descriptor.CompositeDetailDescriptor;
import org.qi4j.tools.model.descriptor.CompositeMethodDetailDescriptor;

public class MethodFinder {
    public List<CompositeMethodDetailDescriptor> findMethod(CompositeDetailDescriptor<?> descriptor) {
        return this.findMethod(descriptor.methods());
    }

    private List<CompositeMethodDetailDescriptor> findMethod(Iterable<CompositeMethodDetailDescriptor> iter) {
        ArrayList<CompositeMethodDetailDescriptor> publicList = new ArrayList<CompositeMethodDetailDescriptor>();
        ArrayList<CompositeMethodDetailDescriptor> privateList = new ArrayList<CompositeMethodDetailDescriptor>();
        for (CompositeMethodDetailDescriptor descriptor : iter) {
            Object compositeDescriptor = descriptor.composite().descriptor();
            Iterable compositeType = compositeDescriptor.types();
            Class<?> mixinMethodClass = descriptor.descriptor().method().getDeclaringClass();
            for (Class compositeClass : compositeType) {
                if (mixinMethodClass.isAssignableFrom(compositeClass)) {
                    publicList.add(descriptor);
                    continue;
                }
                privateList.add(descriptor);
            }
        }
        publicList.addAll(privateList);
        this.doFilter(publicList);
        return publicList;
    }

    private void doFilter(List<CompositeMethodDetailDescriptor> list) {
        if (list.isEmpty()) {
            return;
        }
        Iterator<CompositeMethodDetailDescriptor> iter = list.iterator();
        while (iter.hasNext()) {
            CompositeMethodDetailDescriptor descriptor = iter.next();
            Method method = descriptor.descriptor().method();
            if (Property.class.isAssignableFrom(method.getReturnType())) {
                iter.remove();
                continue;
            }
            if (Association.class.isAssignableFrom(method.getReturnType())) {
                iter.remove();
                continue;
            }
            if (ManyAssociation.class.isAssignableFrom(method.getReturnType())) {
                iter.remove();
                continue;
            }
            if (!NamedAssociation.class.isAssignableFrom(method.getReturnType())) continue;
            iter.remove();
        }
    }
}

