/*
 * Decompiled with CFR 0.152.
 */
package org.qi4j.tools.model.util;

import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.List;
import org.qi4j.api.composite.DependencyDescriptor;
import org.qi4j.api.injection.scope.Service;
import org.qi4j.api.injection.scope.Uses;
import org.qi4j.api.service.ServiceDescriptor;
import org.qi4j.functional.Iterables;
import org.qi4j.tools.model.descriptor.ApplicationDetailDescriptor;
import org.qi4j.tools.model.descriptor.EntityDetailDescriptor;
import org.qi4j.tools.model.descriptor.InjectedFieldDetailDescriptor;
import org.qi4j.tools.model.descriptor.LayerDetailDescriptor;
import org.qi4j.tools.model.descriptor.MixinDetailDescriptor;
import org.qi4j.tools.model.descriptor.ModuleDetailDescriptor;
import org.qi4j.tools.model.descriptor.ObjectDetailDescriptor;
import org.qi4j.tools.model.descriptor.ServiceDetailDescriptor;
import org.qi4j.tools.model.descriptor.ServiceUsage;
import org.qi4j.tools.model.descriptor.TransientDetailDescriptor;
import org.qi4j.tools.model.descriptor.ValueDetailDescriptor;

class ServiceUsageFinder {
    private ServiceDetailDescriptor descriptor;
    private ArrayList<ServiceUsage> usages;

    ServiceUsageFinder() {
    }

    public List<ServiceUsage> findServiceUsage(ServiceDetailDescriptor descriptor) {
        this.usages = new ArrayList();
        this.descriptor = descriptor;
        ApplicationDetailDescriptor appDescriptor = descriptor.module().layer().application();
        this.collectUsage(appDescriptor);
        return this.usages;
    }

    private void collectUsage(ApplicationDetailDescriptor descriptor) {
        for (LayerDetailDescriptor childDescriptor : descriptor.layers()) {
            this.collectInModules(childDescriptor.modules());
        }
    }

    private void collectInModules(Iterable<ModuleDetailDescriptor> iter) {
        for (ModuleDetailDescriptor descriptor : iter) {
            this.collectInServices(descriptor.services());
            this.collectInEntities(descriptor.entities());
            this.collectInValues(descriptor.values());
            this.collectInTransients(descriptor.transients());
            this.collectInObjects(descriptor.objects());
        }
    }

    private void collectInServices(Iterable<ServiceDetailDescriptor> iter) {
        for (ServiceDetailDescriptor descriptor : iter) {
            if (descriptor.equals(this.descriptor)) continue;
            this.collectInMixin(descriptor.mixins());
        }
    }

    private void collectInEntities(Iterable<EntityDetailDescriptor> iter) {
        for (EntityDetailDescriptor descriptor : iter) {
            this.collectInMixin(descriptor.mixins());
        }
    }

    private void collectInValues(Iterable<ValueDetailDescriptor> iter) {
        for (ValueDetailDescriptor descriptor : iter) {
            this.collectInMixin(descriptor.mixins());
        }
    }

    private void collectInTransients(Iterable<TransientDetailDescriptor> iter) {
        for (TransientDetailDescriptor descriptor : iter) {
            this.collectInMixin(descriptor.mixins());
        }
    }

    private void collectInObjects(Iterable<ObjectDetailDescriptor> iter) {
        for (ObjectDetailDescriptor descriptor : iter) {
            this.collectInInjectedField(descriptor.injectedFields(), descriptor);
        }
    }

    private void collectInMixin(Iterable<MixinDetailDescriptor> iter) {
        for (MixinDetailDescriptor descriptor : iter) {
            this.collectInInjectedField(descriptor.injectedFields(), descriptor);
        }
    }

    private void collectInInjectedField(Iterable<InjectedFieldDetailDescriptor> iter, Object ownerDescriptor) {
        for (InjectedFieldDetailDescriptor descriptorField : iter) {
            ServiceUsage usage;
            DependencyDescriptor dependencyDescriptor = descriptorField.descriptor().dependency();
            Annotation annotation = dependencyDescriptor.injectionAnnotation();
            Class<? extends Annotation> clazz = annotation.annotationType();
            if (!Uses.class.equals(clazz) && !Service.class.equals(clazz)) continue;
            boolean used = false;
            if (!dependencyDescriptor.injectionType().equals(Iterables.first((Iterable)((ServiceDescriptor)this.descriptor.descriptor()).types()))) continue;
            if (ownerDescriptor instanceof MixinDetailDescriptor) {
                MixinDetailDescriptor mixinDescriptor = (MixinDetailDescriptor)ownerDescriptor;
                usage = new ServiceUsage(mixinDescriptor.composite(), descriptorField, mixinDescriptor.composite().module(), mixinDescriptor.composite().module().layer());
            } else {
                ObjectDetailDescriptor objectDescriptor = (ObjectDetailDescriptor)ownerDescriptor;
                usage = new ServiceUsage(objectDescriptor, descriptorField, objectDescriptor.module(), objectDescriptor.module().layer());
            }
            this.usages.add(usage);
        }
    }
}

