/*
 * Decompiled with CFR 0.152.
 */
package org.qi4j.migration;

import java.util.Arrays;
import java.util.Map;
import org.qi4j.migration.MigrationEvents;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MigrationEventLogger
implements MigrationEvents {
    protected Logger logger = LoggerFactory.getLogger((String)this.getClass().getName());

    @Override
    public void propertyAdded(String entity, String name, Object value) {
        this.logger.info("Added property " + name + " with value " + (value == null ? "null" : value.toString()) + " in " + entity);
    }

    @Override
    public void propertyRemoved(String entity, String name) {
        this.logger.info("Removed property " + name + " in " + entity);
    }

    @Override
    public void propertyRenamed(String entity, String from, String to) {
        this.logger.info("Renamed property from " + from + " to " + to + " in " + entity);
    }

    @Override
    public void associationAdded(String entity, String name, String value) {
        this.logger.info("Added association " + name + " with value " + value + " in " + entity);
    }

    @Override
    public void associationRemoved(String entity, String name) {
        this.logger.info("Removed association " + name + " in " + entity);
    }

    @Override
    public void associationRenamed(String entity, String from, String to) {
        this.logger.info("Renamed association from " + from + " to " + to + " in " + entity);
    }

    @Override
    public void manyAssociationAdded(String entity, String name, String ... value) {
        this.logger.info("Added many-association " + name + " with values " + Arrays.asList(value) + " in " + entity);
    }

    @Override
    public void manyAssociationRemoved(String entity, String name) {
        this.logger.info("Removed many-association " + name + " in " + entity);
    }

    @Override
    public void manyAssociationRenamed(String entity, String from, String to) {
        this.logger.info("Renamed many-association from " + from + " to " + to + " in " + entity);
    }

    @Override
    public void namedAssociationAdded(String entity, String name, Map<String, String> value) {
        this.logger.info("Added named-association " + name + " with values " + value + " in " + entity);
    }

    @Override
    public void namedAssociationRemoved(String entity, String name) {
        this.logger.info("Removed named-association " + name + " in " + entity);
    }

    @Override
    public void namedAssociationRenamed(String entity, String from, String to) {
        this.logger.info("Renamed named-association from " + from + " to " + to + " in " + entity);
    }

    @Override
    public void entityTypeChanged(String entity, String newEntityType) {
        this.logger.info("Changed entitytype to " + newEntityType + " in " + entity);
    }
}

