/*
 * Decompiled with CFR 0.152.
 */
package org.qi4j.migration.operation;

import org.json.JSONException;
import org.json.JSONObject;
import org.qi4j.migration.Migrator;
import org.qi4j.migration.assembly.EntityMigrationOperation;
import org.qi4j.spi.entitystore.helpers.StateStore;

public class RemoveProperty
implements EntityMigrationOperation {
    private String property;
    private String defaultValue;

    public RemoveProperty(String property, String defaultValue) {
        this.property = property;
        this.defaultValue = defaultValue;
    }

    @Override
    public boolean upgrade(JSONObject state, StateStore stateStore, Migrator migrator) throws JSONException {
        return migrator.removeProperty(state, this.property);
    }

    @Override
    public boolean downgrade(JSONObject state, StateStore stateStore, Migrator migrator) throws JSONException {
        return migrator.addProperty(state, this.property, this.defaultValue);
    }

    public String toString() {
        return "Remove property " + this.property + ", default:" + this.defaultValue;
    }
}

