/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
package org.qi4j.samples.forum.context.signup;

import org.qi4j.api.composite.TransientComposite;
import org.qi4j.api.injection.scope.Service;
import org.qi4j.api.injection.scope.Uses;
import org.qi4j.samples.forum.context.Context;
import org.qi4j.samples.forum.context.Events;

/**
 * TODO
 */
public class Signup
    extends Context
{
    @Uses
    Users users;

    @Service
    Events events;

    public void signup( Registration registration )
    {
        users.signup( registration );
    }

    protected class Users
        implements TransientComposite
    {
        public void signup( Registration registration )
        {
            // Check if user with this name already exists
            events.signedup( registration );
        }
    }
}
