/*
 * Copyright (c) 2008, Edward Yakop. All Rights Reserved.
 *
 * Licensed  under the  Apache License,  Version 2.0  (the "License");
 * you may not use  this file  except in  compliance with the License.
 * You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed  under the  License is distributed on an "AS IS" BASIS,
 * WITHOUT  WARRANTIES OR CONDITIONS  OF ANY KIND, either  express  or
 * implied.
 *
 * See the License for the specific language governing permissions and
 * limitations under the License. 
 */
package org.qi4j.envisage.school.ui.admin;

import org.qi4j.bootstrap.Assembler;
import org.qi4j.bootstrap.AssemblyException;
import org.qi4j.bootstrap.ModuleAssembly;
import org.qi4j.envisage.school.ui.admin.pages.composites.ListSchoolsPageComposite;
import org.qi4j.envisage.school.ui.admin.pages.composites.ListUserPageComposite;
import org.qi4j.envisage.school.ui.admin.pages.composites.UserDetailPageComposite;

import static org.qi4j.api.common.Visibility.layer;

public class AdminAssembler
    implements Assembler
{

    @Override
    public void assemble( ModuleAssembly module )
        throws AssemblyException
    {
        module.transients(
            ListSchoolsPageComposite.class,
            ListUserPageComposite.class,
            UserDetailPageComposite.class
        ).visibleIn( layer );
    }
}
