/**
 *
 * Copyright 2009-2010 Rickard Öberg AB
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.qi4j.library.eventsourcing.domain.replay;

import org.qi4j.library.eventsourcing.domain.api.DomainEventValue;

/**
 * An eventValue replay failed.
 */
public class EventReplayException
        extends RuntimeException
{
    private DomainEventValue eventValue;

    public EventReplayException( DomainEventValue eventValue, Throwable cause )
    {
        super( cause );
        this.eventValue = eventValue;
    }

    @Override
    public String getMessage()
    {
        return "Could not replay event:" + eventValue + ", caused by:" + getCause();
    }
}
