/**
 * QI Analyze is a Java EE framework for identifying and analyzing Quality Indicators
 * Copyright (C) 2010  QIAnalyze LLC http://www.qianalyze.org
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.See the GNU
 * Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see http://www.gnu.org/licenses/
 */
package org.qianalyze.api.module;

import org.qianalyze.api.indicator.IndicatorResult;

/**
 * The abstraction allowing developers to implement their own code to run the
 * rules for a single quality indicator.
 * 
 * @author Matthew Demerath
 * @version 1.0.0
 */
public interface IIndicatorInspector {

    /**
     * 
     * @param data
     *            a serializable <code>Object</code> that the implementing class
     *            can understand.
     * @param indicatorResult
     *            can be the same object returned or a new one. Left for the to
     *            decide.
     * 
     * @return IndicatorResult The results of inspecting this object.
     * 
     * @see IndicatorResult
     */
    IndicatorResult inspect(Object data);
}
