/**
 * QI Analyze is a Java EE framework for identifying and analyzing Quality Indicators
 * Copyright (C) 2010  QIAnalyze LLC http://www.qianalyze.org
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.See the GNU
 * Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see http://www.gnu.org/licenses/
 */
package org.qianalyze.api.module;

/**
 * The abstraction allowing developers to implement their own code to accept XML
 * data and return a response for the entire module (a collection of quality
 * indicators).
 * 
 * @author Matthew Demerath
 * @version 1.0.0
 * 
 */
public interface IModuleInspector {
    /**
     * 
     * @param module
     *            an object representing a collection quality indicators
     * @param xmlPayload
     *            the data the quality indicators should examine.
     * @return ModuleResponse an object representing a collection of
     *         IndicatorResponses
     * 
     * @see Module
     * @see ModuleResponse
     */
    ModuleResponse inspect(Module module, String xmlPayload);
}
