/*
 * Decompiled with CFR 0.152.
 */
package org.qianalyze.maven;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.drools.builder.KnowledgeBuilder;
import org.drools.builder.KnowledgeBuilderConfiguration;
import org.drools.builder.KnowledgeBuilderFactory;
import org.drools.builder.ResourceType;
import org.drools.compiler.DroolsParserException;
import org.drools.core.util.DroolsStreamUtils;
import org.drools.decisiontable.InputType;
import org.drools.decisiontable.SpreadsheetCompiler;
import org.drools.definition.KnowledgePackage;
import org.drools.definition.rule.Rule;
import org.drools.definitions.impl.KnowledgePackageImp;
import org.drools.definitions.rule.impl.RuleImpl;
import org.drools.io.ResourceFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Mojo(name="compile", defaultPhase=LifecyclePhase.COMPILE)
public class DroolsRulesMojo
extends AbstractMojo {
    private static final String DEFAULT_INCLUDES = "**/*.drl,**/*.xls,**/*.rf";
    private File outputDirectory;
    private File sourceDir;
    private List<String> excludes;
    private List<String> includes;
    protected List<String> compileClasspathElements;

    public void execute() throws MojoExecutionException, MojoFailureException {
        try {
            System.out.println(this.outputDirectory.getAbsolutePath());
            this.compileRules();
        }
        catch (Exception e) {
            this.getLog().error((Throwable)e);
            throw new RuntimeException(e);
        }
    }

    public void compileRules() throws DroolsParserException, IOException {
        String targetPath = this.outputDirectory.toString() + "/classes/";
        File target = new File(targetPath);
        if (!target.exists()) {
            target.mkdirs();
        }
        URL modelJarURL = new URL("file", "localhost", targetPath);
        ArrayList<URL> urlList = new ArrayList<URL>();
        urlList.add(modelJarURL);
        List<String> compileClasspathElements = this.compileClasspathElements;
        for (String compileSourccompileClasspathElement : compileClasspathElements) {
            File compileSourceDirectory;
            if (!compileSourccompileClasspathElement.contains("jaxb2-basics-runtime") || (compileSourceDirectory = new File(compileSourccompileClasspathElement)).isDirectory()) continue;
            this.getLog().debug((CharSequence)("Add to projectRealm: " + compileSourceDirectory.toURI().toURL().toString()));
            urlList.add(compileSourceDirectory.toURI().toURL());
        }
        URLClassLoader classLoader = new URLClassLoader(urlList.toArray(new URL[0]));
        KnowledgeBuilderConfiguration kbuilderConf = KnowledgeBuilderFactory.newKnowledgeBuilderConfiguration(null, (ClassLoader[])new ClassLoader[]{classLoader, ((Object)((Object)this)).getClass().getClassLoader()});
        KnowledgeBuilder kbuilder = KnowledgeBuilderFactory.newKnowledgeBuilder((KnowledgeBuilderConfiguration)kbuilderConf);
        if (StringUtils.contains((CharSequence)targetPath, (CharSequence)"Unnamed")) {
            throw new RuntimeException("The project was incorrectly checked out so that maven cannot determine the project name, therefore it creates a directory with Unnamed.  Fix the project or add the name property into the Maven pom.xml");
        }
        this.getLog().debug((CharSequence)("Target directory to write output file - " + targetPath));
        this.getLog().debug((CharSequence)("Resource directory to pull rules from - " + this.sourceDir.getCanonicalPath()));
        List listOfFiles = org.codehaus.plexus.util.FileUtils.getFiles((File)this.sourceDir, (String)this.getIncludesList(), (String)this.getExcludesList(), (boolean)true);
        if (CollectionUtils.isEmpty((Collection)listOfFiles)) {
            this.getLog().warn((CharSequence)"No files were found to compile into package");
        } else {
            for (File file : listOfFiles) {
                if (!file.isFile()) continue;
                String fileName = file.getName();
                String fileSuffix = StringUtils.substringAfterLast((String)fileName, (String)".");
                if (StringUtils.endsWith((CharSequence)fileSuffix, (CharSequence)"drl")) {
                    this.getLog().info((CharSequence)("- Adding DRL: " + fileName + " to package"));
                    kbuilder.add(ResourceFactory.newFileResource((String)file.getAbsolutePath()), ResourceType.DRL);
                } else if (StringUtils.endsWith((CharSequence)fileSuffix, (CharSequence)"xls")) {
                    SpreadsheetCompiler sc = new SpreadsheetCompiler();
                    String drlstr = sc.compile(ResourceFactory.newFileResource((String)file.getAbsolutePath()).getInputStream(), InputType.XLS);
                    this.getLog().debug((CharSequence)("--- XLS compile details = " + drlstr));
                    this.getLog().info((CharSequence)("- Adding Decision Table: " + fileName + " to package"));
                    kbuilder.add(ResourceFactory.newFileResource((String)file.getAbsolutePath()), ResourceType.DTABLE);
                } else if (StringUtils.endsWith((CharSequence)fileSuffix, (CharSequence)"rf")) {
                    this.getLog().info((CharSequence)("- Adding Rule Flow: " + fileName + " to package"));
                    kbuilder.add(ResourceFactory.newFileResource((String)file.getAbsolutePath()), ResourceType.DRF);
                }
                fileName = fileName.replace(fileSuffix, "pkg");
                if (kbuilder.hasErrors()) {
                    this.getLog().error((CharSequence)("Errors " + kbuilder.getErrors().toString()));
                    throw new RuntimeException(kbuilder.getErrors().toString());
                }
                int pkgCount = 0;
                Collection kpkgs = kbuilder.getKnowledgePackages();
                for (KnowledgePackage kpkg : kpkgs) {
                    Collection rules = kpkg.getRules();
                    for (Rule element : rules) {
                        RuleImpl rule = (RuleImpl)element;
                        this.getLog().debug((CharSequence)("<RuleName> : <Activation-Group (null=non-existent)> : <Agenda-group>:   " + rule.getName() + " : " + rule.getRule().getActivationGroup() + " : " + rule.getRule().getRuleFlowGroup()));
                    }
                    if (++pkgCount > 1) {
                        this.getLog().warn((CharSequence)"Your rules are being built into multiple packages, this is most likely an issue.");
                    }
                    FileOutputStream out = null;
                    try {
                        File targetFile = new File(targetPath);
                        if (!targetFile.exists()) {
                            FileUtils.forceMkdir((File)new File(targetPath));
                        }
                        File outFilePath = new File(targetPath + fileName);
                        out = new FileOutputStream(outFilePath);
                        DroolsStreamUtils.streamOut((OutputStream)out, (Object)((KnowledgePackageImp)kpkg).pkg);
                        long filesize = outFilePath.length();
                        long filesizeInKB = filesize / 1024L;
                        this.getLog().info((CharSequence)("- Package " + fileName + " built, putting pkg: " + targetPath + fileName));
                        this.getLog().info((CharSequence)("- Size of " + fileName + " is: " + filesizeInKB + " KB"));
                    }
                    catch (IOException ex) {
                        try {
                            throw new RuntimeException(ex);
                        }
                        catch (Throwable throwable) {
                            IOUtils.closeQuietly(out);
                            throw throwable;
                        }
                    }
                    IOUtils.closeQuietly((OutputStream)out);
                }
            }
        }
    }

    private String getExcludesList() {
        if (CollectionUtils.isNotEmpty(this.excludes)) {
            return this.convertListToCsv(this.excludes);
        }
        return null;
    }

    private String getIncludesList() {
        if (CollectionUtils.isNotEmpty(this.includes)) {
            return this.convertListToCsv(this.includes);
        }
        return DEFAULT_INCLUDES;
    }

    private String convertListToCsv(List<String> includeList) {
        StringBuilder nameBuilder = new StringBuilder();
        for (String includeItem : includeList) {
            nameBuilder.append(includeItem).append(",");
        }
        nameBuilder.deleteCharAt(nameBuilder.length() - 1);
        return nameBuilder.toString();
    }
}

