/*
 * Decompiled with CFR 0.152.
 */
package org.qnixyz.jbson;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import org.apache.commons.lang3.ArrayUtils;
import org.bson.types.Binary;
import org.bson.types.ObjectId;
import org.qnixyz.jbson.JaxBsonFieldContext;

public class JaxBsonToBson {
    private BinaryCollectionToBson binaryCollectionToBson = (fieldCtx, src) -> {
        ArrayList ret = new ArrayList();
        src.forEach(e -> ret.add(fieldCtx.getConfiguration().getToBson().getBinaryToBson().convert(fieldCtx, (Binary)e)));
        return ret;
    };
    private BinaryToBson binaryToBson = (fieldCtx, src) -> src;
    private BooleanArrayToBson booleanArrayToBson = (fieldCtx, src) -> {
        ArrayList<Object> ret = new ArrayList<Object>();
        for (Boolean e : src) {
            ret.add(fieldCtx.getConfiguration().getToBson().getBooleanToBson().convert(fieldCtx, e));
        }
        return ret;
    };
    private BooleanCollectionToBson booleanCollectionToBson = (fieldCtx, src) -> {
        ArrayList ret = new ArrayList();
        src.forEach(e -> ret.add(fieldCtx.getConfiguration().getToBson().getBooleanToBson().convert(fieldCtx, (Boolean)e)));
        return ret;
    };
    private BooleanPrimArrayToBson booleanPrimArrayToBson = (fieldCtx, src) -> Arrays.asList(ArrayUtils.toObject((boolean[])src));
    private BooleanPrimToBson booleanPrimToBson = (fieldCtx, src) -> src;
    private BooleanToBson booleanToBson = (fieldCtx, src) -> src;
    private ByteArrayToBson byteArrayToBson = (fieldCtx, src) -> new Binary(ArrayUtils.toPrimitive((Byte[])src));
    private ByteCollectionToBson byteCollectionToBson = (fieldCtx, src) -> {
        byte[] ret = new byte[src.size()];
        int i = 0;
        for (Byte e : src) {
            if (e != null) {
                ret[i] = e;
            }
            ++i;
        }
        return new Binary(ret);
    };
    private BytePrimArrayToBson bytePrimArrayToBson = (fieldCtx, src) -> new Binary(src);
    private BytePrimToBson bytePrimToBson = (fieldCtx, src) -> new Binary(new byte[]{src});
    private ByteToBson byteToBson = (fieldCtx, src) -> new Binary(new byte[]{src});
    private CharacterArrayToBson characterArrayToBson = (fieldCtx, src) -> new String(ArrayUtils.toPrimitive((Character[])src));
    private CharacterCollectionToBson characterCollectionToBson = (fieldCtx, src) -> {
        char[] ret = new char[src.size()];
        int i = 0;
        for (Character e : src) {
            if (e != null) {
                ret[i] = e.charValue();
            }
            ++i;
        }
        return new String(ret);
    };
    private CharacterPrimArrayToBson characterPrimArrayToBson = (fieldCtx, src) -> new String(src);
    private CharacterPrimToBson characterPrimToBson = (fieldCtx, src) -> Character.valueOf(src).toString();
    private CharacterToBson characterToBson = (fieldCtx, src) -> src.toString();
    private DateBasedArrayToBson dateBasedArrayToBson = (fieldCtx, src) -> {
        ArrayList<Date> ret = new ArrayList<Date>();
        for (Object e : src) {
            ret.add(fieldCtx.getConfiguration().getDateBased().getToBson().convert(e));
        }
        return ret;
    };
    private DateBasedCollectionToBson dateBasedCollectionToBson = (fieldCtx, src) -> {
        ArrayList ret = new ArrayList();
        src.forEach(e -> ret.add(fieldCtx.getConfiguration().getDateBased().getToBson().convert(e)));
        return ret;
    };
    private DateBasedToBson dateBasedToBson = (fieldCtx, src) -> fieldCtx.getConfiguration().getDateBased().getToBson().convert(src);
    private DoublePrimArrayToBson doublePrimArrayToBson = (fieldCtx, src) -> Arrays.asList(ArrayUtils.toObject((double[])src));
    private EnumArrayToBson enumArrayToBson = (fieldCtx, enumType, src) -> {
        ArrayList<Object> ret = new ArrayList<Object>();
        for (Enum e : src) {
            ret.add(fieldCtx.getConfiguration().getToBson().getEnumToBson().convert(fieldCtx, enumType, e));
        }
        return ret;
    };
    private EnumCollectionToBson enumCollectionToBson = (fieldCtx, enumType, src) -> {
        ArrayList<Object> ret = new ArrayList<Object>();
        for (Enum e : src) {
            ret.add(fieldCtx.getConfiguration().getToBson().getEnumToBson().convert(fieldCtx, enumType, e));
        }
        return ret;
    };
    private EnumToBson enumToBson = (fieldCtx, enumType, src) -> fieldCtx.getConfiguration().getIndexedEnum(enumType).enumToString(src);
    private FloatPrimArrayToBson floatPrimArrayToBson = (fieldCtx, src) -> {
        ArrayList<Object> ret = new ArrayList<Object>();
        float[] fArray = src;
        int n = fArray.length;
        for (int i = 0; i < n; ++i) {
            Float e = Float.valueOf(fArray[i]);
            ret.add(fieldCtx.getConfiguration().getToBson().getFloatPrimToBson().convert(fieldCtx, e.floatValue()));
        }
        return ret;
    };
    private FloatPrimToBson floatPrimToBson = (fieldCtx, src) -> Float.valueOf(src).doubleValue();
    private IntegerPrimArrayToBson integerPrimArrayToBson = (fieldCtx, src) -> Arrays.asList(ArrayUtils.toObject((int[])src));
    private LongPrimArrayToBson longPrimArrayToBson = (fieldCtx, src) -> Arrays.asList(ArrayUtils.toObject((long[])src));
    private NumberBasedArrayToBson numberBasedArrayToBson = (fieldCtx, src) -> {
        ArrayList<Object> ret = new ArrayList<Object>();
        for (Object e : src) {
            ret.add(fieldCtx.getConfiguration().getNumberBased().getToBson().convert(fieldCtx, e).getValue());
        }
        return ret;
    };
    private NumberBasedCollectionToBson numberBasedCollectionToBson = (fieldCtx, src) -> {
        ArrayList ret = new ArrayList();
        src.forEach(e -> ret.add(fieldCtx.getConfiguration().getNumberBased().getToBson().convert(fieldCtx, e).getValue()));
        return ret;
    };
    private NumberBasedToBson numberBasedToBson = (fieldCtx, src) -> fieldCtx.getConfiguration().getNumberBased().getToBson().convert(fieldCtx, src).getValue();
    private ObjectIdArrayToBson objectIdArrayToBson = (fieldCtx, src) -> Arrays.asList(src);
    private ObjectIdCollectionToBson objectIdCollectionToBson = (fieldCtx, src) -> src;
    private ObjectIdToBson objectIdToBson = (fieldCtx, src) -> src;
    private ShortPrimArrayToBson shortPrimArrayToBson = (fieldCtx, src) -> {
        ArrayList<Object> ret = new ArrayList<Object>();
        short[] sArray = src;
        int n = sArray.length;
        for (int i = 0; i < n; ++i) {
            Short e = sArray[i];
            ret.add(fieldCtx.getConfiguration().getToBson().getShortPrimToBson().convert(fieldCtx, e));
        }
        return ret;
    };
    private ShortPrimToBson shortPrimToBson = (fieldCtx, src) -> Short.valueOf(src).intValue();
    private StringBasedArrayToBson stringBasedArrayToBson = (fieldCtx, src) -> {
        ArrayList<String> ret = new ArrayList<String>();
        for (Object e : src) {
            ret.add(fieldCtx.getConfiguration().getStringBased().getToBson().convert(e));
        }
        return ret;
    };
    private StringBasedCollectionToBson stringBasedCollectionToBson = (fieldCtx, src) -> {
        ArrayList ret = new ArrayList();
        src.forEach(e -> ret.add(fieldCtx.getConfiguration().getStringBased().getToBson().convert(e)));
        return ret;
    };
    private StringBasedToBson stringBasedToBson = (fieldCtx, src) -> fieldCtx.getConfiguration().getStringBased().getToBson().convert(src);

    public BinaryCollectionToBson getBinaryCollectionToBson() {
        return this.binaryCollectionToBson;
    }

    public BinaryToBson getBinaryToBson() {
        return this.binaryToBson;
    }

    public BooleanArrayToBson getBooleanArrayToBson() {
        return this.booleanArrayToBson;
    }

    public BooleanCollectionToBson getBooleanCollectionToBson() {
        return this.booleanCollectionToBson;
    }

    public BooleanPrimArrayToBson getBooleanPrimArrayToBson() {
        return this.booleanPrimArrayToBson;
    }

    public BooleanPrimToBson getBooleanPrimToBson() {
        return this.booleanPrimToBson;
    }

    public BooleanToBson getBooleanToBson() {
        return this.booleanToBson;
    }

    public ByteArrayToBson getByteArrayToBson() {
        return this.byteArrayToBson;
    }

    public ByteCollectionToBson getByteCollectionToBson() {
        return this.byteCollectionToBson;
    }

    public BytePrimArrayToBson getBytePrimArrayToBson() {
        return this.bytePrimArrayToBson;
    }

    public BytePrimToBson getBytePrimToBson() {
        return this.bytePrimToBson;
    }

    public ByteToBson getByteToBson() {
        return this.byteToBson;
    }

    public CharacterArrayToBson getCharacterArrayToBson() {
        return this.characterArrayToBson;
    }

    public CharacterCollectionToBson getCharacterCollectionToBson() {
        return this.characterCollectionToBson;
    }

    public CharacterPrimArrayToBson getCharacterPrimArrayToBson() {
        return this.characterPrimArrayToBson;
    }

    public CharacterPrimToBson getCharacterPrimToBson() {
        return this.characterPrimToBson;
    }

    public CharacterToBson getCharacterToBson() {
        return this.characterToBson;
    }

    public DateBasedArrayToBson getDateBasedArrayToBson() {
        return this.dateBasedArrayToBson;
    }

    public DateBasedCollectionToBson getDateBasedCollectionToBson() {
        return this.dateBasedCollectionToBson;
    }

    public DateBasedToBson getDateBasedToBson() {
        return this.dateBasedToBson;
    }

    public DoublePrimArrayToBson getDoublePrimArrayToBson() {
        return this.doublePrimArrayToBson;
    }

    public EnumArrayToBson getEnumArrayToBson() {
        return this.enumArrayToBson;
    }

    public EnumCollectionToBson getEnumCollectionToBson() {
        return this.enumCollectionToBson;
    }

    public EnumToBson getEnumToBson() {
        return this.enumToBson;
    }

    public FloatPrimArrayToBson getFloatPrimArrayToBson() {
        return this.floatPrimArrayToBson;
    }

    public FloatPrimToBson getFloatPrimToBson() {
        return this.floatPrimToBson;
    }

    public IntegerPrimArrayToBson getIntegerPrimArrayToBson() {
        return this.integerPrimArrayToBson;
    }

    public LongPrimArrayToBson getLongPrimArrayToBson() {
        return this.longPrimArrayToBson;
    }

    public NumberBasedArrayToBson getNumberBasedArrayToBson() {
        return this.numberBasedArrayToBson;
    }

    public NumberBasedCollectionToBson getNumberBasedCollectionToBson() {
        return this.numberBasedCollectionToBson;
    }

    public NumberBasedToBson getNumberBasedToBson() {
        return this.numberBasedToBson;
    }

    public ObjectIdArrayToBson getObjectIdArrayToBson() {
        return this.objectIdArrayToBson;
    }

    public ObjectIdCollectionToBson getObjectIdCollectionToBson() {
        return this.objectIdCollectionToBson;
    }

    public ObjectIdToBson getObjectIdToBson() {
        return this.objectIdToBson;
    }

    public ShortPrimArrayToBson getShortPrimArrayToBson() {
        return this.shortPrimArrayToBson;
    }

    public ShortPrimToBson getShortPrimToBson() {
        return this.shortPrimToBson;
    }

    public StringBasedArrayToBson getStringBasedArrayToBson() {
        return this.stringBasedArrayToBson;
    }

    public StringBasedCollectionToBson getStringBasedCollectionToBson() {
        return this.stringBasedCollectionToBson;
    }

    public StringBasedToBson getStringBasedToBson() {
        return this.stringBasedToBson;
    }

    public void setBinaryCollectionToBson(BinaryCollectionToBson binaryCollectionToBson) {
        this.binaryCollectionToBson = Objects.requireNonNull(binaryCollectionToBson);
    }

    public void setBinaryToBson(BinaryToBson binaryToBson) {
        this.binaryToBson = Objects.requireNonNull(binaryToBson);
    }

    public void setBooleanArrayToBson(BooleanArrayToBson booleanArrayToBson) {
        this.booleanArrayToBson = Objects.requireNonNull(booleanArrayToBson);
    }

    public void setBooleanCollectionToBson(BooleanCollectionToBson booleanCollectionToBson) {
        this.booleanCollectionToBson = Objects.requireNonNull(booleanCollectionToBson);
    }

    public void setBooleanPrimArrayToBson(BooleanPrimArrayToBson booleanPrimArrayToBson) {
        this.booleanPrimArrayToBson = Objects.requireNonNull(booleanPrimArrayToBson);
    }

    public void setBooleanPrimToBson(BooleanPrimToBson booleanPrimToBson) {
        this.booleanPrimToBson = Objects.requireNonNull(booleanPrimToBson);
    }

    public void setBooleanToBson(BooleanToBson booleanToBson) {
        this.booleanToBson = Objects.requireNonNull(booleanToBson);
    }

    public void setByteArrayToBson(ByteArrayToBson byteArrayToBson) {
        this.byteArrayToBson = Objects.requireNonNull(byteArrayToBson);
    }

    public void setByteCollectionToBson(ByteCollectionToBson byteCollectionToBson) {
        this.byteCollectionToBson = Objects.requireNonNull(byteCollectionToBson);
    }

    public void setBytePrimArrayToBson(BytePrimArrayToBson bytePrimArrayToBson) {
        this.bytePrimArrayToBson = Objects.requireNonNull(bytePrimArrayToBson);
    }

    public void setBytePrimToBson(BytePrimToBson bytePrimToBson) {
        this.bytePrimToBson = Objects.requireNonNull(bytePrimToBson);
    }

    public void setByteToBson(ByteToBson byteToBson) {
        this.byteToBson = Objects.requireNonNull(byteToBson);
    }

    public void setCharacterArrayToBson(CharacterArrayToBson characterArrayToBson) {
        this.characterArrayToBson = Objects.requireNonNull(characterArrayToBson);
    }

    public void setCharacterCollectionToBson(CharacterCollectionToBson characterCollectionToBson) {
        this.characterCollectionToBson = Objects.requireNonNull(characterCollectionToBson);
    }

    public void setCharacterPrimArrayToBson(CharacterPrimArrayToBson characterPrimArrayToBson) {
        this.characterPrimArrayToBson = Objects.requireNonNull(characterPrimArrayToBson);
    }

    public void setCharacterPrimToBson(CharacterPrimToBson characterPrimToBson) {
        this.characterPrimToBson = Objects.requireNonNull(characterPrimToBson);
    }

    public void setCharacterToBson(CharacterToBson characterToBson) {
        this.characterToBson = Objects.requireNonNull(characterToBson);
    }

    public void setDateBasedArrayToBson(DateBasedArrayToBson dateBasedArrayToBson) {
        this.dateBasedArrayToBson = Objects.requireNonNull(dateBasedArrayToBson);
    }

    public void setDateBasedCollectionToBson(DateBasedCollectionToBson dateBasedCollectionToBson) {
        this.dateBasedCollectionToBson = Objects.requireNonNull(dateBasedCollectionToBson);
    }

    public void setDateBasedToBson(DateBasedToBson dateBasedToBson) {
        this.dateBasedToBson = Objects.requireNonNull(dateBasedToBson);
    }

    public void setDoublePrimArrayToBson(DoublePrimArrayToBson doublePrimArrayToBson) {
        this.doublePrimArrayToBson = Objects.requireNonNull(doublePrimArrayToBson);
    }

    public void setEnumArrayToBson(EnumArrayToBson enumArrayToBson) {
        this.enumArrayToBson = Objects.requireNonNull(enumArrayToBson);
    }

    public void setEnumCollectionToBson(EnumCollectionToBson enumCollectionToBson) {
        this.enumCollectionToBson = Objects.requireNonNull(enumCollectionToBson);
    }

    public void setEnumToBson(EnumToBson enumToBson) {
        this.enumToBson = Objects.requireNonNull(enumToBson);
    }

    public void setFloatPrimArrayToBson(FloatPrimArrayToBson floatPrimArrayToBson) {
        this.floatPrimArrayToBson = Objects.requireNonNull(floatPrimArrayToBson);
    }

    public void setFloatPrimToBson(FloatPrimToBson floatPrimToBson) {
        this.floatPrimToBson = Objects.requireNonNull(floatPrimToBson);
    }

    public void setIntegerPrimArrayToBson(IntegerPrimArrayToBson integerPrimArrayToBson) {
        this.integerPrimArrayToBson = Objects.requireNonNull(integerPrimArrayToBson);
    }

    public void setLongPrimArrayToBson(LongPrimArrayToBson longPrimArrayToBson) {
        this.longPrimArrayToBson = Objects.requireNonNull(longPrimArrayToBson);
    }

    public void setNumberBasedArrayToBson(NumberBasedArrayToBson numberBasedArrayToBson) {
        this.numberBasedArrayToBson = Objects.requireNonNull(numberBasedArrayToBson);
    }

    public void setNumberBasedCollectionToBson(NumberBasedCollectionToBson numberBasedCollectionToBson) {
        this.numberBasedCollectionToBson = Objects.requireNonNull(numberBasedCollectionToBson);
    }

    public void setNumberBasedToBson(NumberBasedToBson numberBasedToBson) {
        this.numberBasedToBson = Objects.requireNonNull(numberBasedToBson);
    }

    public void setObjectIdArrayToBson(ObjectIdArrayToBson objectIdArrayToBson) {
        this.objectIdArrayToBson = Objects.requireNonNull(objectIdArrayToBson);
    }

    public void setObjectIdCollectionToBson(ObjectIdCollectionToBson objectIdCollectionToBson) {
        this.objectIdCollectionToBson = Objects.requireNonNull(objectIdCollectionToBson);
    }

    public void setObjectIdToBson(ObjectIdToBson objectIdToBson) {
        this.objectIdToBson = Objects.requireNonNull(objectIdToBson);
    }

    public void setShortPrimArrayToBson(ShortPrimArrayToBson shortPrimArrayToBson) {
        this.shortPrimArrayToBson = Objects.requireNonNull(shortPrimArrayToBson);
    }

    public void setShortPrimToBson(ShortPrimToBson shortPrimToBson) {
        this.shortPrimToBson = Objects.requireNonNull(shortPrimToBson);
    }

    public void setStringBasedArrayToBson(StringBasedArrayToBson stringBasedArrayToBson) {
        this.stringBasedArrayToBson = Objects.requireNonNull(stringBasedArrayToBson);
    }

    public void setStringBasedCollectionToBson(StringBasedCollectionToBson stringBasedCollectionToBson) {
        this.stringBasedCollectionToBson = Objects.requireNonNull(stringBasedCollectionToBson);
    }

    public void setStringBasedToBson(StringBasedToBson stringBasedToBson) {
        this.stringBasedToBson = Objects.requireNonNull(stringBasedToBson);
    }

    @FunctionalInterface
    public static interface BinaryCollectionToBson {
        public Object convert(JaxBsonFieldContext var1, Collection<Binary> var2);
    }

    @FunctionalInterface
    public static interface BinaryToBson {
        public Object convert(JaxBsonFieldContext var1, Binary var2);
    }

    @FunctionalInterface
    public static interface BooleanArrayToBson {
        public Object convert(JaxBsonFieldContext var1, Boolean[] var2);
    }

    @FunctionalInterface
    public static interface BooleanCollectionToBson {
        public Object convert(JaxBsonFieldContext var1, Collection<Boolean> var2);
    }

    @FunctionalInterface
    public static interface BooleanPrimArrayToBson {
        public Object convert(JaxBsonFieldContext var1, boolean[] var2);
    }

    @FunctionalInterface
    public static interface BooleanPrimToBson {
        public Object convert(JaxBsonFieldContext var1, boolean var2);
    }

    @FunctionalInterface
    public static interface BooleanToBson {
        public Object convert(JaxBsonFieldContext var1, Boolean var2);
    }

    @FunctionalInterface
    public static interface ByteArrayToBson {
        public Object convert(JaxBsonFieldContext var1, Byte[] var2);
    }

    @FunctionalInterface
    public static interface ByteCollectionToBson {
        public Object convert(JaxBsonFieldContext var1, Collection<Byte> var2);
    }

    @FunctionalInterface
    public static interface BytePrimArrayToBson {
        public Object convert(JaxBsonFieldContext var1, byte[] var2);
    }

    @FunctionalInterface
    public static interface BytePrimToBson {
        public Object convert(JaxBsonFieldContext var1, byte var2);
    }

    @FunctionalInterface
    public static interface ByteToBson {
        public Object convert(JaxBsonFieldContext var1, Byte var2);
    }

    @FunctionalInterface
    public static interface CharacterArrayToBson {
        public Object convert(JaxBsonFieldContext var1, Character[] var2);
    }

    @FunctionalInterface
    public static interface CharacterCollectionToBson {
        public Object convert(JaxBsonFieldContext var1, Collection<Character> var2);
    }

    @FunctionalInterface
    public static interface CharacterPrimArrayToBson {
        public Object convert(JaxBsonFieldContext var1, char[] var2);
    }

    @FunctionalInterface
    public static interface CharacterPrimToBson {
        public Object convert(JaxBsonFieldContext var1, char var2);
    }

    @FunctionalInterface
    public static interface CharacterToBson {
        public Object convert(JaxBsonFieldContext var1, Character var2);
    }

    @FunctionalInterface
    public static interface DateBasedArrayToBson {
        public List<Date> convert(JaxBsonFieldContext var1, Object[] var2);
    }

    @FunctionalInterface
    public static interface DateBasedCollectionToBson {
        public List<Date> convert(JaxBsonFieldContext var1, Collection<Object> var2);
    }

    @FunctionalInterface
    public static interface DateBasedToBson {
        public Date convert(JaxBsonFieldContext var1, Object var2);
    }

    @FunctionalInterface
    public static interface DoublePrimArrayToBson {
        public Object convert(JaxBsonFieldContext var1, double[] var2);
    }

    @FunctionalInterface
    public static interface EnumArrayToBson {
        public Object convert(JaxBsonFieldContext var1, Class<?> var2, Enum<?>[] var3);
    }

    @FunctionalInterface
    public static interface EnumCollectionToBson {
        public Object convert(JaxBsonFieldContext var1, Class<?> var2, Collection<Enum<?>> var3);
    }

    @FunctionalInterface
    public static interface EnumToBson {
        public Object convert(JaxBsonFieldContext var1, Class<?> var2, Enum<?> var3);
    }

    @FunctionalInterface
    public static interface FloatPrimArrayToBson {
        public Object convert(JaxBsonFieldContext var1, float[] var2);
    }

    @FunctionalInterface
    public static interface FloatPrimToBson {
        public Object convert(JaxBsonFieldContext var1, float var2);
    }

    @FunctionalInterface
    public static interface IntegerPrimArrayToBson {
        public Object convert(JaxBsonFieldContext var1, int[] var2);
    }

    @FunctionalInterface
    public static interface LongPrimArrayToBson {
        public Object convert(JaxBsonFieldContext var1, long[] var2);
    }

    @FunctionalInterface
    public static interface NumberBasedArrayToBson {
        public List<Object> convert(JaxBsonFieldContext var1, Object[] var2);
    }

    @FunctionalInterface
    public static interface NumberBasedCollectionToBson {
        public List<Object> convert(JaxBsonFieldContext var1, Collection<Object> var2);
    }

    @FunctionalInterface
    public static interface NumberBasedToBson {
        public Object convert(JaxBsonFieldContext var1, Object var2);
    }

    @FunctionalInterface
    public static interface ObjectIdArrayToBson {
        public Object convert(JaxBsonFieldContext var1, ObjectId[] var2);
    }

    @FunctionalInterface
    public static interface ObjectIdCollectionToBson {
        public Object convert(JaxBsonFieldContext var1, Collection<ObjectId> var2);
    }

    @FunctionalInterface
    public static interface ObjectIdToBson {
        public Object convert(JaxBsonFieldContext var1, ObjectId var2);
    }

    @FunctionalInterface
    public static interface ShortPrimArrayToBson {
        public Object convert(JaxBsonFieldContext var1, short[] var2);
    }

    @FunctionalInterface
    public static interface ShortPrimToBson {
        public Object convert(JaxBsonFieldContext var1, short var2);
    }

    @FunctionalInterface
    public static interface StringBasedArrayToBson {
        public List<String> convert(JaxBsonFieldContext var1, Object[] var2);
    }

    @FunctionalInterface
    public static interface StringBasedCollectionToBson {
        public List<String> convert(JaxBsonFieldContext var1, Collection<Object> var2);
    }

    @FunctionalInterface
    public static interface StringBasedToBson {
        public String convert(JaxBsonFieldContext var1, Object var2);
    }
}

