/*
 * Decompiled with CFR 0.152.
 */
package org.qnixyz.jbson.annotations.cfg;

import java.lang.reflect.Field;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import org.qnixyz.jbson.annotations.JaxBsonName;
import org.qnixyz.jbson.annotations.cfg.JaxBsonNameImpl;
import org.qnixyz.jbson.annotations.cfg.Utils;

public class JaxBsonNameFieldMap {
    private Map<Field, JaxBsonName> map;

    public boolean containsKey(Field field) {
        if (this.map == null) {
            return false;
        }
        return this.map.containsKey(field);
    }

    public JaxBsonName get(Field field) {
        Objects.requireNonNull(field);
        if (this.map == null) {
            return null;
        }
        return this.map.get(field);
    }

    public Set<Field> getKeySet() {
        if (this.map == null) {
            return Collections.emptySet();
        }
        return this.map.keySet();
    }

    public boolean isEmpty() {
        return this.map == null || this.map.isEmpty();
    }

    public JaxBsonNameFieldMap put(Field field, JaxBsonName jaxBsonName) {
        Objects.requireNonNull(field);
        if (this.map == null) {
            this.map = new HashMap<Field, JaxBsonName>();
        }
        this.map.put(field, jaxBsonName);
        return this;
    }

    public JaxBsonName remove(Field field) {
        if (this.map == null) {
            return null;
        }
        return this.map.remove(field);
    }

    public static class XmlAdapter
    extends javax.xml.bind.annotation.adapters.XmlAdapter<JaxBsonNameFieldMapType, JaxBsonNameFieldMap> {
        public JaxBsonNameFieldMapType marshal(JaxBsonNameFieldMap v) throws Exception {
            if (v == null || v.isEmpty()) {
                return null;
            }
            JaxBsonNameFieldMapType ret = new JaxBsonNameFieldMapType();
            for (Map.Entry e : v.map.entrySet()) {
                ret.add(new JaxBsonNameFieldMapEntry((Field)e.getKey(), (JaxBsonName)e.getValue()));
            }
            return ret;
        }

        public JaxBsonNameFieldMap unmarshal(JaxBsonNameFieldMapType v) throws Exception {
            if (v == null || v.isEmpty()) {
                return null;
            }
            JaxBsonNameFieldMap ret = new JaxBsonNameFieldMap();
            for (JaxBsonNameFieldMapEntry e : v.set) {
                Field field = Utils.declaredFieldByName(e.fieldClass, e.fieldName);
                if (ret.containsKey(field)) {
                    throw new IllegalStateException("Multiple definitions of JaxBsonNameMap field: " + e.fieldClass + "." + e.fieldName);
                }
                ret.put(field, e.jaxBsonName);
            }
            return ret;
        }
    }

    @XmlAccessorType(value=XmlAccessType.FIELD)
    private static class JaxBsonNameFieldMapType {
        @JaxBsonName(name="entries")
        @XmlElement(name="entry")
        private SortedSet<JaxBsonNameFieldMapEntry> set;

        private JaxBsonNameFieldMapType() {
        }

        private void add(JaxBsonNameFieldMapEntry e) {
            Objects.requireNonNull(e);
            if (this.set == null) {
                this.set = new TreeSet<JaxBsonNameFieldMapEntry>();
            }
            this.set.add(e);
        }

        private boolean isEmpty() {
            return this.set == null || this.set.isEmpty();
        }
    }

    @XmlAccessorType(value=XmlAccessType.FIELD)
    private static class JaxBsonNameFieldMapEntry
    implements Comparable<JaxBsonNameFieldMapEntry> {
        @XmlAttribute(required=true)
        private String fieldClass;
        @XmlAttribute(required=true)
        private String fieldName;
        @XmlElement(required=true)
        private JaxBsonNameImpl jaxBsonName;

        private JaxBsonNameFieldMapEntry() {
        }

        private JaxBsonNameFieldMapEntry(Field field, JaxBsonName jaxBsonName) {
            this.fieldClass = field.getDeclaringClass().getName();
            this.fieldName = field.getName();
            if (jaxBsonName != null) {
                this.jaxBsonName = jaxBsonName instanceof JaxBsonNameImpl ? (JaxBsonNameImpl)jaxBsonName : new JaxBsonNameImpl(jaxBsonName);
            }
        }

        @Override
        public int compareTo(JaxBsonNameFieldMapEntry o) {
            if (o == null) {
                return 1;
            }
            int ret = org.qnixyz.jbson.impl.Utils.compare(this.fieldClass, o.fieldClass);
            if (ret != 0) {
                return ret;
            }
            ret = org.qnixyz.jbson.impl.Utils.compare(this.fieldName, o.fieldName);
            if (ret != 0) {
                return ret;
            }
            return 0;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            JaxBsonNameFieldMapEntry other = (JaxBsonNameFieldMapEntry)obj;
            if (this.fieldClass == null ? other.fieldClass != null : !this.fieldClass.equals(other.fieldClass)) {
                return false;
            }
            return !(this.fieldName == null ? other.fieldName != null : !this.fieldName.equals(other.fieldName));
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.fieldClass == null ? 0 : this.fieldClass.hashCode());
            result = 31 * result + (this.fieldName == null ? 0 : this.fieldName.hashCode());
            return result;
        }
    }
}

