/*
 * Decompiled with CFR 0.152.
 */
package org.qnixyz.jbson.annotations.cfg;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import org.qnixyz.jbson.annotations.JaxBsonName;
import org.qnixyz.jbson.annotations.cfg.JaxBsonNameImpl;
import org.qnixyz.jbson.annotations.cfg.Utils;

public class JaxBsonNameTypeMap {
    private Map<Class<?>, JaxBsonName> map;

    public boolean containsKey(Class<?> key) {
        if (this.map == null) {
            return false;
        }
        return this.map.containsKey(key);
    }

    public JaxBsonName get(Class<?> field) {
        Objects.requireNonNull(field);
        if (this.map == null) {
            return null;
        }
        return this.map.get(field);
    }

    public Set<Class<?>> getKeySet() {
        if (this.map == null) {
            return Collections.emptySet();
        }
        return this.map.keySet();
    }

    public boolean isEmpty() {
        return this.map == null || this.map.isEmpty();
    }

    public JaxBsonNameTypeMap put(Class<?> field, JaxBsonName jaxBsonName) {
        Objects.requireNonNull(field);
        if (this.map == null) {
            this.map = new HashMap();
        }
        this.map.put(field, jaxBsonName);
        return this;
    }

    public JaxBsonName remove(Class<?> field) {
        if (this.map == null) {
            return null;
        }
        return this.map.remove(field);
    }

    public static class XmlAdapter
    extends javax.xml.bind.annotation.adapters.XmlAdapter<JaxBsonNameTypeMapType, JaxBsonNameTypeMap> {
        public JaxBsonNameTypeMapType marshal(JaxBsonNameTypeMap v) throws Exception {
            if (v == null || v.isEmpty()) {
                return null;
            }
            JaxBsonNameTypeMapType ret = new JaxBsonNameTypeMapType();
            for (Map.Entry e : v.map.entrySet()) {
                ret.add(new JaxBsonNameTypeMapEntry((Class)e.getKey(), (JaxBsonName)e.getValue()));
            }
            return ret;
        }

        public JaxBsonNameTypeMap unmarshal(JaxBsonNameTypeMapType v) throws Exception {
            if (v == null || v.isEmpty()) {
                return null;
            }
            JaxBsonNameTypeMap ret = new JaxBsonNameTypeMap();
            for (JaxBsonNameTypeMapEntry e : v.set) {
                Class<?> type = Utils.classByNamne(e.typeClass);
                if (ret.containsKey(type)) {
                    throw new IllegalStateException("Multiple definitions of JaxBsonNameMap type: " + e.typeClass);
                }
                ret.put(type, e.jaxBsonName);
            }
            return ret;
        }
    }

    @XmlAccessorType(value=XmlAccessType.FIELD)
    private static class JaxBsonNameTypeMapType {
        @JaxBsonName(name="entries")
        @XmlElement(name="entry")
        private SortedSet<JaxBsonNameTypeMapEntry> set;

        private JaxBsonNameTypeMapType() {
        }

        private void add(JaxBsonNameTypeMapEntry e) {
            Objects.requireNonNull(e);
            if (this.set == null) {
                this.set = new TreeSet<JaxBsonNameTypeMapEntry>();
            }
            this.set.add(e);
        }

        private boolean isEmpty() {
            return this.set == null || this.set.isEmpty();
        }
    }

    @XmlAccessorType(value=XmlAccessType.FIELD)
    private static class JaxBsonNameTypeMapEntry
    implements Comparable<JaxBsonNameTypeMapEntry> {
        @XmlElement(required=true)
        private JaxBsonNameImpl jaxBsonName;
        @XmlAttribute(required=true)
        private String typeClass;

        private JaxBsonNameTypeMapEntry() {
        }

        private JaxBsonNameTypeMapEntry(Class<?> type, JaxBsonName jaxBsonName) {
            this.typeClass = type.getName();
            if (jaxBsonName != null) {
                this.jaxBsonName = jaxBsonName instanceof JaxBsonNameImpl ? (JaxBsonNameImpl)jaxBsonName : new JaxBsonNameImpl(jaxBsonName);
            }
        }

        @Override
        public int compareTo(JaxBsonNameTypeMapEntry o) {
            if (o == null) {
                return 1;
            }
            int ret = org.qnixyz.jbson.impl.Utils.compare(this.typeClass, o.typeClass);
            if (ret != 0) {
                return ret;
            }
            return 0;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            JaxBsonNameTypeMapEntry other = (JaxBsonNameTypeMapEntry)obj;
            return !(this.typeClass == null ? other.typeClass != null : !this.typeClass.equals(other.typeClass));
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.typeClass == null ? 0 : this.typeClass.hashCode());
            return result;
        }
    }
}

